/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CreateDocumentationTask
extends Task {
    private File destdir = null;
    private File agentSystemDir = null;
    private File laTexFile = null;
    private FileWriter laTexWriter;

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public void execute() throws BuildException {
        super.execute();
        this.agentSystemDir = new File(this.destdir.getParentFile().getParent(), "//src//de//renew//agent//wfms");
        this.laTexFile = new File(this.destdir, "documentation.tex");
        System.out.println(this.laTexFile.getPath());
        try {
            this.laTexWriter = new FileWriter(this.laTexFile);
            this.laTexWriter.write("\\documentclass[a4paper]{article} \n\\usepackage{ngerman} \n\\usepackage{ifthen} \n\\usepackage{alltt} \n\\usepackage{graphicx} \n \n\\usepackage{listings} \n \n\\newenvironment{netdocDocument} {} {} \n\\newenvironment{netdocDescription} {\\begin{alltt}} {\\end{alltt}} \n\\newcommand*{ \\netdocDrawingName} [1] {} \n\\newcommand*{ \\netdocDrawingPackage} [1] {} \n\\newcommand*{ \\netdocTitle} [1] {#1  \\\\} \n\\newcommand*{ \\netdocAuthor} [1] {#1 \\\\} \n\\newcommand*{ \\netdocDateCreation} [1] {#1 \\\\} \n\\newcommand*{ \\netdocDateLastModified} [1] {#1 \\\\} \n \n \n \n\\begin{document} \n \n\\lstset{breaklines} \n \n\\tableofcontents{} \n \n\\newpage \n \n");
        }
        catch (IOException iOException) {
            System.out.println("IOException: problem while opening or writing in latexfile with filewriter");
        }
        try {
            this.createAgentChapter(this.agentSystemDir);
            this.createInteractionChapter(this.agentSystemDir);
            this.createSpecialChapter(this.agentSystemDir);
            this.laTexWriter.write("\\section{Verweis auf JavaDoc-Datei der Ontologie = index.html} \n \n");
            this.laTexWriter.write("\n \n \n \\end{document}");
            this.laTexWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException: Error while creating LaTex-File");
        }
    }

    private void createAgentChapter(File file) throws IOException {
        this.laTexWriter.write("\\section{Agenten} \n \n");
        File file2 = new File(file, "agents");
        File[] fileArray = file2.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory() || fileArray[i].getName() == "CVS") continue;
            File file3 = fileArray[i];
            File[] fileArray2 = file3.listFiles();
            try {
                this.docuWisFile(fileArray2, file3);
                this.docuRnwFiles(fileArray2);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("can not find file");
            }
        }
    }

    private void createInteractionChapter(File file) throws IOException {
        this.laTexWriter.write("\\section{Interaktionen} \n \n");
        File file2 = new File(file, "interactions");
        File[] fileArray = file2.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory() || fileArray[i].getName() == "CVS") continue;
            File file3 = fileArray[i];
            File[] fileArray2 = file3.listFiles();
            this.docuAipFile(fileArray2, file3);
            this.docuRnwFiles(fileArray2);
        }
    }

    private void createSpecialChapter(File file) throws IOException {
        this.laTexWriter.write("\\section{Weitere Netze} \n \n\\subsection{Netze} \n \n");
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName() == "agents" || fileArray[i].getName() == "interactions" || !fileArray[i].isDirectory() || fileArray[i].getName() == "CVS") continue;
            File file2 = fileArray[i];
            File[] fileArray2 = file2.listFiles();
            this.docuRnwFiles(fileArray2);
        }
    }

    private void fileCopy(File file, File file2) {
        try {
            int n;
            FileReader fileReader = new FileReader(file);
            FileWriter fileWriter = new FileWriter(file2);
            while ((n = fileReader.read()) != -1) {
                fileWriter.write(n);
            }
            fileReader.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("file copy error");
        }
    }

    private void docuWisFile(File[] fileArray, File file) throws FileNotFoundException, IOException {
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().equalsIgnoreCase(file.getName() + ".wis")) continue;
            String string = fileArray[i].getName().replaceFirst(".wis", "");
            this.laTexWriter.write("\\subsection{" + string + "} \n \n");
            this.laTexWriter.write("\\subsubsection{" + fileArray[i].getName() + "} \n\\begin{lstlisting} \n");
            File file2 = fileArray[i];
            File file3 = new File(this.destdir, file2.getName());
            this.fileCopy(file2, file3);
            FileReader fileReader = new FileReader(file2);
            try {
                int n;
                while ((n = fileReader.read()) != -1) {
                    this.laTexWriter.write((char)n);
                }
            }
            catch (IOException iOException) {
                System.out.println("Error while working on files");
            }
            try {
                this.laTexWriter.flush();
                fileReader.close();
            }
            catch (IOException iOException) {
                System.out.println("unable to close wisFileReader");
            }
            this.laTexWriter.write("\\end{lstlisting} \n");
            break;
        }
    }

    private void docuAipFile(File[] fileArray, File file) throws IOException {
        block4: for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().equalsIgnoreCase(file.getName() + ".aip")) continue;
            String string = fileArray[i].getName().replaceFirst(".aip", "");
            this.laTexWriter.write("\\subsection{" + string + "} \n \n");
            this.laTexWriter.write("\\subsubsection{" + string + "} \n \n\\includegraphics[width=\\textwidth, height=\\textheight]{" + string + ".eps} \n");
            this.laTexWriter.write("\\caption{" + string + "} \n");
            File file2 = fileArray[i];
            File file3 = new File(this.destdir, file2.getName());
            this.fileCopy(file2, file3);
            String string2 = new String(file2.getName().substring(0, file2.getName().length() - 4));
            for (int j = 0; j < fileArray.length; ++j) {
                if (!fileArray[j].getName().equals(string2 + ".doctex")) continue;
                File file4 = fileArray[j];
                File file5 = new File(this.destdir, file4.getName());
                this.fileCopy(file4, file5);
                try {
                    this.laTexWriter.write("\\input {" + file4.getName() + "} \n");
                }
                catch (IOException iOException) {
                    System.out.println("");
                }
                break block4;
            }
            break;
        }
        try {
            this.laTexWriter.flush();
        }
        catch (IOException iOException) {
            System.out.println("OVERFLUSH!!!");
        }
    }

    private void docuRnwFiles(File[] fileArray) throws IOException {
        block6: for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(".rnw")) continue;
            File file = fileArray[i];
            File file2 = new File(this.destdir, file.getName());
            this.fileCopy(file, file2);
            String string = new String(file.getName().substring(0, file.getName().length() - 4));
            try {
                String string2 = string.replace("_", "\\_");
                this.laTexWriter.write("\\subsubsection{" + string2 + ".rnw} \n\\includegraphics[angle=90, width=\\textwidth, height=19cm]{" + string + ".eps} \n");
                this.laTexWriter.write("\\caption{" + string2 + "} \n");
            }
            catch (IOException iOException) {
                System.out.println("unable to write into LaTex-file");
            }
            for (int j = 0; j < fileArray.length; ++j) {
                if (!fileArray[j].getName().equals(string + ".doctex")) continue;
                File file3 = fileArray[j];
                File file4 = new File(this.destdir, file3.getName());
                this.fileCopy(file3, file4);
                try {
                    this.laTexWriter.write("\\input {" + file3.getName() + "} \n");
                }
                catch (IOException iOException) {
                    System.out.println("IOException: error while writing doctex-file-link into latex-file");
                }
                continue block6;
            }
        }
        try {
            this.laTexWriter.flush();
        }
        catch (IOException iOException) {
            System.out.println("OVERFLUSH!!!");
        }
    }
}

