/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenuItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public class CommandMenu
extends JMenu
implements ActionListener {
    public static Logger logger = Logger.getLogger(CommandMenu.class);
    private Map<Command, CommandMenuItem> commandItems = new HashMap<Command, CommandMenuItem>();

    public CommandMenu(String string) {
        super(string);
        this.checkEnabled();
    }

    @Override
    public synchronized JMenuItem add(JMenuItem jMenuItem) {
        if (jMenuItem instanceof CommandMenuItem) {
            CommandMenuItem commandMenuItem = (CommandMenuItem)jMenuItem;
            Command command = commandMenuItem.getCommand();
            if (this.commandItems.containsKey(command)) {
                throw new IllegalArgumentException("Cannot add command " + command.name() + ": it already exists in the menu.");
            }
            this.commandItems.put(command, commandMenuItem);
            commandMenuItem.addActionListener(this);
            JMenuItem jMenuItem2 = super.add(commandMenuItem);
            this.checkEnabled();
            return jMenuItem2;
        }
        return super.add(jMenuItem);
    }

    @Override
    public synchronized Component add(Component component, int n) {
        if (component instanceof CommandMenuItem) {
            CommandMenuItem commandMenuItem = (CommandMenuItem)component;
            Command command = commandMenuItem.getCommand();
            if (this.commandItems.containsKey(command)) {
                throw new IllegalArgumentException("Cannot add command " + command.name() + ": it already exists in the menu.");
            }
            this.commandItems.put(command, commandMenuItem);
            commandMenuItem.addActionListener(this);
            Component component2 = super.add(component, n);
            this.checkEnabled();
            return component2;
        }
        return super.add(component, n);
    }

    public synchronized void add(Command command) {
        this.add(new CommandMenuItem(command));
    }

    public synchronized void add(Command command, int n) {
        this.add(new CommandMenuItem(command, n));
    }

    public synchronized void add(Command command, int n, int n2) {
        this.add(new CommandMenuItem(command, n, n2));
    }

    public synchronized void remove(Command command) {
        CommandMenuItem commandMenuItem = this.commandItems.get(command);
        if (commandMenuItem == null) {
            throw new IllegalArgumentException("Cannot remove command " + command.name() + ": it does not exist in the menu.");
        }
        this.remove(commandMenuItem);
    }

    @Override
    public synchronized void remove(JMenuItem jMenuItem) {
        if (jMenuItem instanceof CommandMenuItem) {
            CommandMenuItem commandMenuItem = (CommandMenuItem)jMenuItem;
            Command command = commandMenuItem.getCommand();
            if (this.commandItems.get(command) != jMenuItem) {
                throw new IllegalArgumentException("Cannot remove item for command " + command.name() + ": the item is insconsistent with the menu.");
            }
            this.commandItems.remove(command);
            commandMenuItem.removeActionListener(this);
        }
        super.remove(jMenuItem);
    }

    public synchronized boolean checkEnabled() {
        boolean bl = false;
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            boolean bl2;
            Component component = this.getMenuComponent(i);
            if (component == null) {
                return false;
            }
            if (component instanceof CommandMenuItem) {
                bl2 = ((CommandMenuItem)component).getCommand().isExecutable();
                component.setEnabled(bl2);
                bl |= bl2;
                continue;
            }
            if (component instanceof CommandMenu) {
                bl2 = ((CommandMenu)component).checkEnabled();
                component.setEnabled(bl2);
                bl |= bl2;
                continue;
            }
            if (component instanceof JSeparator) continue;
            bl |= component.isEnabled();
        }
        return bl;
    }

    public synchronized void updateCommandText() {
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            Component component = this.getMenuComponent(i);
            if (component == null) {
                return;
            }
            if (component instanceof CommandMenuItem) {
                Command command = ((CommandMenuItem)component).getCommand();
                String string = command.name();
                String string2 = ((AbstractButton)component).getText();
                if (string2 == null || string == null || string2.equals(string)) continue;
                ((AbstractButton)component).setText(string);
                continue;
            }
            if (!(component instanceof CommandMenu)) continue;
            ((CommandMenu)component).updateCommandText();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof CommandMenuItem) {
            Command command = ((CommandMenuItem)object).getCommand();
            command.execute();
        }
    }
}

