/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.URI;
import org.apache.log4j.Logger;

public class TargetTool
extends CreationTool {
    public static Logger logger = Logger.getLogger(TargetTool.class);
    private static final String TARGET_LOCATION = "targetLocation";
    protected FloatingTextField fTextField;
    private Figure fTypingTarget;

    public TargetTool(DrawingEditor drawingEditor) {
        super(drawingEditor, new TextFigure(false));
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        TextFigure textFigure = null;
        if (this.fTypingTarget != null) {
            this.endEdit();
            this.editor().toolDone();
        } else {
            this.fTypingTarget = this.drawing().findFigureInside(n, n2);
            if (this.fTypingTarget != null) {
                String string = (String)this.fTypingTarget.getAttribute(TARGET_LOCATION);
                super.mouseDown(mouseEvent, n, n2);
                textFigure = (TextFigure)this.createdFigure();
                if (string != null) {
                    textFigure.setText(string);
                } else {
                    textFigure.setText("");
                }
                this.beginEdit(textFigure);
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.endEdit();
    }

    @Override
    public void activate() {
        super.activate();
    }

    protected boolean isTypingActive() {
        return this.fTypingTarget != null;
    }

    public void beginEdit(TextFigure textFigure) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
            this.fTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                        TargetTool.this.deactivate();
                        TargetTool.this.editor().toolDone();
                    }
                }
            });
        }
        this.fTextField.setText(textFigure.getText());
        this.fTextField.createOverlay((Container)((Object)this.view()), this.fieldBounds(textFigure), textFigure.getFont());
        this.view().remove(textFigure);
    }

    public void setCaretPosition(int n, int n2) {
        this.fTextField.setCaretPosition(n, n2);
    }

    public void endEdit() {
        if (this.fTypingTarget != null) {
            String string = this.fTextField.getText();
            String string2 = (String)this.fTypingTarget.getAttribute(TARGET_LOCATION);
            if (string.equals("")) {
                this.fTypingTarget.setAttribute(TARGET_LOCATION, null);
            } else {
                try {
                    URI uRI;
                    if (!string.startsWith("sim") && (uRI = new URI(string)).isAbsolute()) {
                        uRI.toURL();
                    }
                    this.fTypingTarget.setAttribute(TARGET_LOCATION, string);
                }
                catch (Exception exception) {
                    logger.error((Object)("Renaming link failed for : " + string));
                    logger.debug((Object)exception);
                }
            }
            this.fTypingTarget = null;
            this.fTextField.endOverlay();
            this.view().checkDamage();
            if (string2 != null) {
                if (!string2.equals(string)) {
                    this.changesMade();
                    this.intermediateUndoSnapshot();
                } else {
                    this.noChangesMade();
                }
            } else if (!string.equals("")) {
                this.changesMade();
                this.intermediateUndoSnapshot();
            } else {
                this.noChangesMade();
            }
        }
    }

    private Rectangle fieldBounds(TextHolder textHolder) {
        Rectangle rectangle = textHolder.textDisplayBox();
        return rectangle;
    }
}

