/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.util.Command;
import java.util.HashSet;
import java.util.Vector;

public class SelectCommand
extends Command {
    public static final int SELECT = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int RESTRICT = 3;
    public static final int INVERT = 4;
    protected DrawingEditor fEditor;
    protected FigureFilter fFilter;
    protected int selectMode;

    public SelectCommand(String string) {
        this(string, Figure.class, null, 0);
    }

    public SelectCommand(String string, Class<?> clazz) {
        this(string, clazz, 0);
    }

    public SelectCommand(String string, Class<?> clazz, int n) {
        this(string, clazz, null, n);
    }

    public SelectCommand(String string, Class<?> clazz, Class<?> clazz2) {
        this(string, clazz, clazz2, 0);
    }

    public SelectCommand(String string, final Class<?> clazz, final Class<?> clazz2, int n) {
        this(string, new FigureFilter(){

            @Override
            public boolean isUsed(Figure figure) {
                return clazz.isInstance(figure) && (clazz2 == null || clazz2.isInstance(((ChildFigure)figure).parent()));
            }
        }, n);
    }

    public SelectCommand(String string, FigureFilter figureFilter) {
        this(string, figureFilter, 0);
    }

    public SelectCommand(String string, FigureFilter figureFilter, int n) {
        super(string);
        this.fFilter = figureFilter;
        this.selectMode = n;
    }

    @Override
    public void execute() {
        DrawingView drawingView = DrawPlugin.getCurrent().getDrawingEditor().view();
        Drawing drawing = drawingView.drawing();
        FigureEnumeration figureEnumeration = drawing.figures();
        Vector<Figure> vector = new Vector<Figure>();
        FigureEnumeration figureEnumeration2 = drawingView.selectionElements();
        HashSet<Figure> hashSet = new HashSet<Figure>();
        while (figureEnumeration2.hasMoreElements()) {
            hashSet.add(figureEnumeration2.nextFigure());
        }
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (this.selectMode != 4) {
                if (this.fFilter.isUsed(figure)) {
                    if (this.selectMode == 3) continue;
                    vector.addElement(figure);
                    continue;
                }
                if (this.selectMode != 3) continue;
                vector.addElement(figure);
                continue;
            }
            if (hashSet.contains(figure)) continue;
            vector.addElement(figure);
        }
        switch (this.selectMode) {
            case 2: 
            case 3: {
                drawingView.removeFromSelectionAll(vector);
                break;
            }
            case 0: 
            case 4: {
                drawingView.clearSelection();
            }
            default: {
                drawingView.addToSelectionAll(vector);
            }
        }
        drawingView.checkDamage();
    }
}

