/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PolygonHandle
extends AbstractHandle {
    private int fIndex;
    private Locator fLocator;

    public PolygonHandle(PolygonFigure polygonFigure, Locator locator, int n) {
        super(polygonFigure);
        this.fLocator = locator;
        this.fIndex = n;
    }

    @Override
    public void invokeStart(MouseEvent mouseEvent, int n, int n2, DrawingView drawingView) {
        super.invokeStart(mouseEvent, n, n2, drawingView);
        if (mouseEvent.getClickCount() > 1) {
            this.myOwner().removePointAt(this.fIndex);
            drawingView.selectionInvalidateHandles();
        }
    }

    @Override
    public void invokeStep(MouseEvent mouseEvent, int n, int n2, int n3, int n4, DrawingView drawingView) {
        Point point;
        PolygonFigure polygonFigure = this.myOwner();
        if (mouseEvent.isControlDown() && this.fIndex >= 0 && this.fIndex < polygonFigure.pointCount()) {
            int n5 = this.fIndex - 1;
            int n6 = this.fIndex + 1;
            if (this.fIndex == 0) {
                n5 = polygonFigure.pointCount() - 1;
            } else if (this.fIndex == polygonFigure.pointCount() - 1) {
                n6 = 0;
            }
            Point point2 = polygonFigure.pointAt(n5);
            Point point3 = polygonFigure.pointAt(n6);
            Point point4 = new Point(point2.x, point3.y);
            Point point5 = new Point(point3.x, point2.y);
            point = Geom.length(n, n2, point4.x, point4.y) < Geom.length(n, n2, point5.x, point5.y) ? point4 : point5;
        } else {
            point = new Point(n, n2);
        }
        this.myOwner().setPointAt(point, this.fIndex);
    }

    @Override
    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.myOwner().smoothPoints();
        super.invokeEnd(n, n2, n3, n4, drawingView);
    }

    @Override
    public Point locate() {
        return this.fLocator.locate(this.owner());
    }

    private PolygonFigure myOwner() {
        return (PolygonFigure)this.owner();
    }
}

