/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.util.Iconkit;
import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorAction;
import de.renew.navigator.NavigatorConfigurator;
import de.renew.navigator.NavigatorExtension;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.NavigatorPlugin;
import de.renew.navigator.events.DirectoryOpeningEvent;
import de.renew.navigator.gui.DefaultFileTreeCellRenderer;
import de.renew.navigator.gui.DragDropListener;
import de.renew.navigator.gui.FileTreeCellRenderer;
import de.renew.navigator.gui.FileTreeNode;
import de.renew.navigator.gui.TreeExpansionListener;
import de.renew.navigator.gui.TreeKeyListener;
import de.renew.navigator.gui.TreeMouseListener;
import de.renew.navigator.gui.actions.AddFilesAction;
import de.renew.navigator.gui.actions.CollapseAllAction;
import de.renew.navigator.gui.actions.ExpandAction;
import de.renew.navigator.gui.actions.OpenHomeAction;
import de.renew.navigator.gui.actions.OpenNetPathAction;
import de.renew.navigator.gui.actions.RefreshAllAction;
import de.renew.navigator.gui.actions.RemoveAllAction;
import de.renew.navigator.gui.actions.RemoveOneAction;
import de.renew.navigator.gui.filters.JavaSearchFilter;
import de.renew.navigator.gui.filters.RNWSearchFilter;
import de.renew.navigator.models.BackgroundTask;
import de.renew.navigator.models.Directory;
import de.renew.navigator.models.Leaf;
import de.renew.navigator.models.Model;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.SearchFilter;
import de.renew.navigator.models.TreeElement;
import de.renew.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

class NavigatorGuiImpl
extends JFrame
implements NavigatorGui,
Observer {
    public static final long serialVersionUID = 97936353687387679L;
    private static Logger logger = Logger.getLogger(NavigatorGuiImpl.class);
    private final FilesystemController filesystem;
    private final NavigatorFileTree model;
    private final List<NavigatorAction> actions;
    private final JPanel menuPanel = new JPanel();
    private final JTextField searchField = new JTextField();
    private final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("rootNode");
    private final DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    private final JTree tree = new JTree(this.treeModel);
    private final JPanel filterPanel = new JPanel();
    private final JPanel tasksPanel = new JPanel();
    private final HashMap<NavigatorAction, Component> actionMapper = new HashMap();
    private final DefaultFileTreeCellRenderer treeCellRenderer = new DefaultFileTreeCellRenderer();
    private final List<NavigatorExtension> extensions;
    public boolean _initialized = false;
    private boolean updating = false;

    public NavigatorGuiImpl(FilesystemController filesystemController, NavigatorPlugin navigatorPlugin) {
        super("Navigator");
        this.model = navigatorPlugin.getModel();
        this.model.addObserver(this);
        this.actions = new ArrayList<NavigatorAction>();
        this.filesystem = filesystemController;
        this.extensions = new LinkedList<NavigatorExtension>();
        Container container = this.getContentPane();
        this.setPreferredSize(new Dimension(320, 640));
        this.setLocation(0, 150);
        this.setIconImage(Iconkit.instance().getImage("/de/renew/navigator/images/eclipse-icons/eview16/filenav_nav.gif"));
        Dimension dimension = new Dimension(-1, 20);
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.menuPanel.setLayout(new BoxLayout(this.menuPanel, 2));
        this.menuPanel.setPreferredSize(dimension);
        this.menuPanel.setMaximumSize(dimension);
        gridBagConstraints.gridy = 0;
        container.add((Component)this.menuPanel, gridBagConstraints);
        this.initMenuBar();
        this.filterPanel.setLayout(new BoxLayout(this.filterPanel, 2));
        this.filterPanel.setPreferredSize(dimension);
        this.filterPanel.setMaximumSize(dimension);
        gridBagConstraints.gridy = 1;
        container.add((Component)this.filterPanel, gridBagConstraints);
        this.initFilterBar();
        TreeMouseListener treeMouseListener = new TreeMouseListener(this);
        TreeKeyListener treeKeyListener = new TreeKeyListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setRootVisible(false);
        this.tree.setFocusable(true);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.addMouseListener(treeMouseListener);
        this.tree.addKeyListener(treeKeyListener);
        this.tree.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 0));
        this.tree.setCellRenderer(this.treeCellRenderer);
        this.tree.setLargeModel(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setAlignmentX(0.0f);
        jPanel.setBackground(Color.WHITE);
        jPanel.add((Component)this.tree, "Before");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 20;
        this.tasksPanel.setLayout(new BoxLayout(this.tasksPanel, 3));
        container.add((Component)this.tasksPanel, gridBagConstraints);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(this.model));
        new DropTarget(this, (DropTargetListener)((Object)new DragDropListener(filesystemController)));
        this._initialized = true;
        this.updateGui(true);
        this.pack();
    }

    @Override
    public void openWindow() {
        if (this.isVisible()) {
            this.toFront();
            return;
        }
        this.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.setVisible(false);
    }

    public void updateGui(boolean bl) {
        Object object;
        if (this.updating) {
            return;
        }
        this.updating = true;
        this.closeAll();
        Object object2 = this.model.getTreeRoots().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            FileTreeNode fileTreeNode = this.renderNode((TreeElement)object);
            if (fileTreeNode == null) continue;
            this.rootNode.add(fileTreeNode);
        }
        this.updateTree();
        this.expandFromModel();
        if (bl && (object2 = this.model.getTextSearch()) != null && ((SearchFilter)object2).getTerms().size() > 0) {
            object = ((SearchFilter)object2).getTerms().get(0);
            this.searchField.setText((String)object);
        }
        this.updateBackgroundTasks();
        this.repaint();
        this.updating = false;
    }

    @Override
    public void addExtension(NavigatorExtension navigatorExtension) {
        this.extensions.add(navigatorExtension);
        navigatorExtension.configure(new NavigatorConfigurator(){

            @Override
            public void addMenuAction(NavigatorAction navigatorAction) {
                if (NavigatorGuiImpl.this.actionMapper.containsKey(navigatorAction)) {
                    return;
                }
                NavigatorGuiImpl.this.actionMapper.put(navigatorAction, NavigatorGuiImpl.this.createButton(NavigatorGuiImpl.this.menuPanel, navigatorAction));
            }

            @Override
            public void addFilterAction(NavigatorAction navigatorAction) {
                if (NavigatorGuiImpl.this.actionMapper.containsKey(navigatorAction)) {
                    return;
                }
                NavigatorGuiImpl.this.actionMapper.put(navigatorAction, NavigatorGuiImpl.this.createButton(NavigatorGuiImpl.this.filterPanel, navigatorAction));
            }

            @Override
            public void addFileTreeCellRenderer(FileTreeCellRenderer fileTreeCellRenderer) {
                NavigatorGuiImpl.this.treeCellRenderer.addAdditionalRenderer(fileTreeCellRenderer);
            }
        });
    }

    @Override
    public boolean removeExtension(NavigatorExtension navigatorExtension) {
        if (!this.extensions.remove(navigatorExtension)) {
            return false;
        }
        navigatorExtension.configure(new NavigatorConfigurator(){

            @Override
            public void addMenuAction(NavigatorAction navigatorAction) {
                NavigatorGuiImpl.this.menuPanel.remove(NavigatorGuiImpl.this.actionMapper.remove(navigatorAction));
            }

            @Override
            public void addFilterAction(NavigatorAction navigatorAction) {
                NavigatorGuiImpl.this.filterPanel.remove(NavigatorGuiImpl.this.actionMapper.remove(navigatorAction));
            }

            @Override
            public void addFileTreeCellRenderer(FileTreeCellRenderer fileTreeCellRenderer) {
                NavigatorGuiImpl.this.treeCellRenderer.removeAdditionalRenderer(fileTreeCellRenderer);
            }
        });
        this.repaint();
        return true;
    }

    @Override
    public DefaultFileTreeCellRenderer getTreeCellRenderer() {
        return this.treeCellRenderer;
    }

    public void initFilterBar() {
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = NavigatorGuiImpl.this.searchField.getText();
                if (string.isEmpty()) {
                    NavigatorGuiImpl.this.model.setTextSearch(null);
                } else {
                    NavigatorGuiImpl.this.model.setTextSearch(new SearchFilter("search", SearchFilter.Type.CONTAINS, false, string));
                }
                NavigatorGuiImpl.this.model.notifyObservers(NavigatorGuiImpl.this.searchField);
            }
        });
        Dimension dimension = new Dimension(198, 20);
        this.searchField.setMaximumSize(dimension);
        this.searchField.setPreferredSize(dimension);
        this.searchField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.filterPanel.add(this.searchField);
        this.createButton(this.filterPanel, new NavigatorAction("Clear Filter", "/de/renew/navigator/images/clear.png", null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigatorGuiImpl.this.model.setTextSearch(null);
                NavigatorGuiImpl.this.searchField.setText("");
                NavigatorGuiImpl.this.model.notifyObservers(NavigatorGuiImpl.this.searchField);
            }
        });
        this.createButton(this.filterPanel, (NavigatorAction)new RNWSearchFilter(this.model));
        this.createButton(this.filterPanel, (NavigatorAction)new JavaSearchFilter(this.model));
    }

    @Deprecated
    public JButton createButton(String string, NavigatorAction navigatorAction) {
        return this.createButton(this.getPanelForContext(string), navigatorAction);
    }

    public List<FileTreeNode> getSelectedNodes() {
        TreePath[] treePathArray;
        ArrayList<FileTreeNode> arrayList = new ArrayList<FileTreeNode>();
        for (TreePath treePath : treePathArray = this.getSelectedTreePaths()) {
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof FileTreeNode)) continue;
            arrayList.add((FileTreeNode)object);
        }
        return arrayList;
    }

    public TreePath[] getSelectedTreePaths() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        return treePathArray == null ? new TreePath[]{} : treePathArray;
    }

    public void openSelected() {
        TreePath[] treePathArray;
        for (TreePath treePath : treePathArray = this.getSelectedTreePaths()) {
            FileTreeNode fileTreeNode;
            File file;
            Object object = treePath.getLastPathComponent();
            if (object == null || !(object instanceof FileTreeNode) || (file = (fileTreeNode = (FileTreeNode)object).getFile()).isDirectory()) continue;
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    if (NavigatorGuiImpl.this.filesystem.isExternallyOpenedFile(file)) {
                        if (Desktop.isDesktopSupported()) {
                            try {
                                Desktop desktop = Desktop.getDesktop();
                                desktop.open(file);
                            }
                            catch (IOException | UnsupportedOperationException exception) {
                                String string = StringUtil.getExtension((String)file.getName());
                                DrawApplication drawApplication = DrawPlugin.getGui();
                                drawApplication.showStatus("Error: Files of type ." + string + " cannot be opened by renew on this platform.");
                            }
                        } else {
                            String string = StringUtil.getExtension((String)file.getName());
                            DrawApplication drawApplication = DrawPlugin.getGui();
                            drawApplication.showStatus("Error: Files of type ." + string + " cannot be opened by renew on this platform.");
                        }
                    } else {
                        DrawPlugin.getGui().openOrLoadDrawing(file.getPath());
                    }
                    return null;
                }
            };
            swingWorker.execute();
        }
    }

    public void showContextMenu(int n, int n2) {
        Object object;
        Object object2;
        TreePath treePath = this.tree.getPathForLocation(n, n2);
        if (null == treePath) {
            return;
        }
        Object object3 = treePath.getLastPathComponent();
        if (object3 == null || !(object3 instanceof FileTreeNode)) {
            return;
        }
        final FileTreeNode fileTreeNode = (FileTreeNode)object3;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (fileTreeNode.getParent() == this.rootNode) {
            object2 = new RemoveOneAction(this, this.model);
            object = new JMenuItem((Action)object2);
            ((AbstractButton)object).setText(((NavigatorAction)object2).getActionName());
            jPopupMenu.add((JMenuItem)object);
        }
        object = ((String)(object2 = System.getProperty("os.name"))).equals("Mac OS X") ? "Finder" : "Explorer";
        JMenuItem jMenuItem = new JMenuItem("Reveal in " + (String)object);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    File file = fileTreeNode.getFile();
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    desktop.open(file);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "Could not reveal.");
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        for (NavigatorExtension navigatorExtension : this.extensions) {
            JMenuItem jMenuItem2 = navigatorExtension.getMenuItem(this.tree, n, n2, object3, fileTreeNode);
            if (jMenuItem2 == null) continue;
            jPopupMenu.add(jMenuItem2);
            jPopupMenu.repaint();
        }
        jPopupMenu.show(this.tree, n, n2);
    }

    public void closeAll() {
        this.rootNode.removeAllChildren();
        this.treeModel.nodeStructureChanged(this.rootNode);
    }

    @Override
    public void collapseAll() {
        logger.debug((Object)"------------> COLLAPSE ALL");
        for (TreeElement treeElement : this.model.getTreeRoots()) {
            if (!(treeElement instanceof Directory)) continue;
            ((Directory)treeElement).setOpened(false);
        }
        this.model.notifyObservers();
    }

    @Override
    public void expand() {
        logger.debug((Object)"------------> EXPAND RECURSIVE");
        try {
            TreePath treePath = this.tree.getSelectionPath();
            TreeExpansionListener.setActive(false);
            if (treePath != null) {
                FileTreeNode fileTreeNode = (FileTreeNode)treePath.getLastPathComponent();
                TreeElement treeElement = fileTreeNode.getModel();
                if (treeElement instanceof Directory) {
                    treeElement.expandAll();
                } else {
                    Model model = treeElement.getParent();
                    if (model instanceof Directory) {
                        ((Directory)model).expandAll();
                    }
                }
            } else {
                this.model.expandAll();
            }
            this.model.notifyObservers();
            TreeExpansionListener.setActive(true);
            this.tree.fireTreeExpanded(treePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeSelectedNodes() {
        List<TreeElement> list = this.getSelectedElements();
        for (TreeElement treeElement : list) {
            if (treeElement.getParent() instanceof NavigatorFileTree) {
                this.model.remove(treeElement);
                continue;
            }
            treeElement.setExcluded(true);
        }
        this.model.notifyObservers();
    }

    @Override
    public List<TreeElement> getSelectedElements() {
        LinkedList<TreeElement> linkedList = new LinkedList<TreeElement>();
        List<FileTreeNode> list = this.getSelectedNodes();
        for (FileTreeNode fileTreeNode : list) {
            linkedList.add(fileTreeNode.getModel());
        }
        return linkedList;
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }

    @Override
    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public void removeMenuButton(JButton jButton) {
        this.menuPanel.remove(jButton);
        this.menuPanel.validate();
        this.menuPanel.repaint();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(NavigatorGuiImpl.class.getSimpleName() + ": removing button: " + String.valueOf(jButton)));
        }
    }

    public List<NavigatorAction> getActions() {
        return this.actions;
    }

    public void updateBackgroundTasks() {
        this.tasksPanel.removeAll();
        for (BackgroundTask backgroundTask : this.model.getBackgroundTasks()) {
            this.renderTask(backgroundTask);
        }
        this.tasksPanel.revalidate();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable == this.model) {
            if (object instanceof DirectoryOpeningEvent) {
                DirectoryOpeningEvent directoryOpeningEvent = (DirectoryOpeningEvent)object;
                this.toggleNode(directoryOpeningEvent.getNode(), directoryOpeningEvent.isOpening());
                return;
            }
            this.updateGui(object != this.searchField);
        }
    }

    @Override
    public List<NavigatorExtension> getExtensions() {
        return this.extensions;
    }

    private void toggleNode(FileTreeNode fileTreeNode, boolean bl) {
        if (bl) {
            this.tree.expandPath(fileTreeNode.getPath());
            return;
        }
        this.tree.collapsePath(fileTreeNode.getPath());
    }

    private JButton createButton(JPanel jPanel, NavigatorAction navigatorAction) {
        Dimension dimension = new Dimension(33, 20);
        final JButton jButton = new JButton(navigatorAction);
        jButton.setMinimumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setAlignmentX(0.0f);
        navigatorAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!propertyChangeEvent.getPropertyName().equals("active")) {
                    return;
                }
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                jButton.setSelected(bl);
            }
        });
        jPanel.add(jButton);
        jPanel.validate();
        jPanel.repaint();
        return jButton;
    }

    private void updateTree() {
        this.treeModel.reload();
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    private void expandFromModel() {
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            FileTreeNode fileTreeNode = (FileTreeNode)this.rootNode.getChildAt(i);
            for (FileTreeNode fileTreeNode2 : fileTreeNode.getOpenedDirectories()) {
                TreePath treePath = fileTreeNode2.getPath();
                this.tree.expandPath(treePath);
            }
        }
    }

    private void renderTask(final BackgroundTask backgroundTask) {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        final JLabel jLabel = new JLabel(backgroundTask.getName());
        final JButton jButton = new JButton();
        final JProgressBar jProgressBar = new JProgressBar();
        Observer observer = new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                if (observable instanceof BackgroundTask) {
                    BackgroundTask backgroundTask = (BackgroundTask)observable;
                    jLabel.setText(backgroundTask.getName() + " " + Math.round(backgroundTask.getCurrent() * 100.0f) + " %");
                    jButton.setEnabled(backgroundTask.isCancelable());
                    jProgressBar.setMinimum(0);
                    jProgressBar.setMaximum(Integer.MAX_VALUE);
                    jProgressBar.setValue(Math.round(backgroundTask.getCurrent() * 2.1474836E9f));
                    jProgressBar.setIndeterminate(backgroundTask.isIndeterminate());
                }
            }
        };
        backgroundTask.addObserver(observer);
        observer.update(backgroundTask, null);
        jPanel.setMinimumSize(new Dimension(-1, 50));
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jLabel.setLabelFor(jProgressBar);
        jLabel.setBackground(Color.RED);
        jPanel2.add(jLabel);
        jProgressBar.setBackground(Color.BLUE);
        jPanel2.add(jProgressBar);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jButton.setAction(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                backgroundTask.cancel();
            }
        });
        jPanel.add(jButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tasksPanel.add(jPanel);
    }

    private void initMenuBar() {
        this.createButton(this.menuPanel, (NavigatorAction)new OpenHomeAction(this.filesystem));
        this.createButton(this.menuPanel, (NavigatorAction)new OpenNetPathAction(this.filesystem));
        this.createButton(this.menuPanel, (NavigatorAction)new AddFilesAction(this.filesystem));
        this.createButton(this.menuPanel, (NavigatorAction)new ExpandAction(this));
        this.createButton(this.menuPanel, (NavigatorAction)new CollapseAllAction(this));
        this.createButton(this.menuPanel, (NavigatorAction)new RefreshAllAction(this.filesystem));
        this.createButton(this.menuPanel, (NavigatorAction)new RemoveOneAction(this, this.model));
        this.createButton(this.menuPanel, (NavigatorAction)new RemoveAllAction(this.model));
    }

    private void expandRecursively(TreePath treePath, TreeNode treeNode) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2;
            TreeNode treeNode3 = enumeration.nextElement();
            if (!(treeNode3 instanceof TreeNode) || (treeNode2 = treeNode3).isLeaf()) continue;
            this.expandRecursively(treePath.pathByAddingChild(treeNode2), treeNode2);
        }
        this.tree.expandPath(treePath);
    }

    @Deprecated
    private JPanel getPanelForContext(String string) {
        if (string.equals("menu")) {
            return this.menuPanel;
        }
        return this.filterPanel;
    }

    private FileTreeNode renderNode(TreeElement treeElement) {
        if (treeElement.isExcluded()) {
            return null;
        }
        if (treeElement instanceof Directory) {
            return this.renderDirectoryModel((Directory)treeElement);
        }
        if (treeElement instanceof Leaf) {
            return this.renderFileNode((Leaf)treeElement);
        }
        throw new RuntimeException("model must be either File or Directory.");
    }

    private FileTreeNode renderDirectoryModel(Directory directory) {
        FileTreeNode fileTreeNode = new FileTreeNode(directory);
        int n = 0;
        for (TreeElement treeElement : directory.getChildren()) {
            FileTreeNode fileTreeNode2 = this.renderNode(treeElement);
            if (fileTreeNode2 == null) continue;
            fileTreeNode.add(fileTreeNode2);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        return fileTreeNode;
    }

    private FileTreeNode renderFileNode(Leaf leaf) {
        return this.shouldRenderFileNode(leaf) ? new FileTreeNode(leaf) : null;
    }

    private boolean shouldRenderFileNode(Leaf leaf) {
        int n = 0;
        String string = leaf.getName();
        if (this.model.getTextSearch() != null && !this.model.getTextSearch().match(string)) {
            return false;
        }
        for (SearchFilter searchFilter : this.model.getActiveFileFilters()) {
            if (!searchFilter.isValid()) continue;
            ++n;
            if (!searchFilter.match(string)) continue;
            return true;
        }
        return n == 0;
    }
}

