/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class ChangeSizeCommand
extends UndoableCommand {
    public static final int DEFAULT_SIZE = 1;
    public static final int FIRST_FIGURE = 2;
    private static final int SPECIFIED = 0;
    private int mode;
    private Dimension useSize;

    public ChangeSizeCommand(String string, int n) {
        super(string);
        if (n == 0) {
            throw new RuntimeException("ChangeSizeCommand: Invalid mode.");
        }
        this.mode = n;
        this.useSize = null;
    }

    public ChangeSizeCommand(String string, Dimension dimension) {
        super(string);
        this.mode = 0;
        this.useSize = dimension;
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        if (this.mode == 2) {
            return this.getEditor().view().selectionCount() > 1;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    public synchronized boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getEditor().view().selectionElements();
            if (this.mode == 2) {
                Figure figure = figureEnumeration.nextFigure();
                this.useSize = figure.displayBox().getSize();
            }
            while (figureEnumeration.hasMoreElements()) {
                Figure figure = figureEnumeration.nextFigure();
                Rectangle rectangle = figure.displayBox();
                Point point = rectangle.getLocation();
                Dimension dimension = rectangle.getSize();
                Dimension dimension2 = this.getNewSize(figure);
                if (dimension2 == null) continue;
                Point point2 = new Point(point.x - (dimension2.width - dimension.width) / 2, point.y - (dimension2.height - dimension.height) / 2);
                Rectangle rectangle2 = new Rectangle(point2, dimension2);
                figure.displayBox(rectangle2);
            }
            this.getEditor().view().checkDamage();
            return true;
        }
        return false;
    }

    protected Dimension getNewSize(Figure figure) {
        if (this.mode == 1) {
            if (figure instanceof PlaceFigure) {
                return PlaceFigure.defaultDimension();
            }
            if (figure instanceof TransitionFigure) {
                return TransitionFigure.defaultDimension();
            }
            return null;
        }
        return this.useSize;
    }
}

