/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamechannel;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.TransitionFigure;
import de.renew.refactoring.match.DownlinkMatch;
import de.renew.refactoring.match.LinkMatch;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.match.UplinkMatch;
import de.renew.refactoring.parse.LinkParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

class RenameChannelSelectedLinkFinder {
    private static Logger logger = Logger.getLogger(RenameChannelSelectedLinkFinder.class);
    private final LinkParser _parser;
    private final Drawing _drawing;
    private final Figure _selectedFigure;

    RenameChannelSelectedLinkFinder(LinkParser linkParser, Drawing drawing, List<Figure> list) {
        this._parser = linkParser;
        this._drawing = drawing;
        this._selectedFigure = list.size() == 1 ? list.get(0) : null;
    }

    boolean isTextFigureOrTransitionFigureSelected() {
        return this._selectedFigure instanceof CPNTextFigure || this._selectedFigure instanceof TransitionFigure;
    }

    boolean isLinkSelected() {
        return this.findSelectedLinks().size() > 0;
    }

    List<LinkMatch> findSelectedLinks() {
        CPNTextFigure cPNTextFigure;
        if (this._selectedFigure instanceof TransitionFigure) {
            return this.findLinks((TransitionFigure)this._selectedFigure);
        }
        if (this._selectedFigure instanceof CPNTextFigure && RenameChannelSelectedLinkFinder.hasParentTransitionFigure(cPNTextFigure = (CPNTextFigure)this._selectedFigure)) {
            return this.findLinks(cPNTextFigure);
        }
        return Collections.emptyList();
    }

    private List<LinkMatch> findLinks(CPNTextFigure cPNTextFigure) {
        ArrayList<LinkMatch> arrayList = new ArrayList<LinkMatch>();
        String string = cPNTextFigure.getText();
        StringMatch stringMatch = this._parser.findUplink(string);
        if (stringMatch != null) {
            StringMatch stringMatch2 = this._parser.findChannelName(stringMatch.match());
            int n = this._parser.findParameterCount(stringMatch.match());
            arrayList.add(new UplinkMatch(this._drawing, cPNTextFigure, stringMatch, stringMatch2, n));
        }
        for (StringMatch stringMatch3 : this._parser.findDownlinks(string)) {
            StringMatch stringMatch4 = this._parser.findChannelName(stringMatch3.match());
            int n = this._parser.findParameterCount(stringMatch3.match());
            arrayList.add(new DownlinkMatch(this._drawing, cPNTextFigure, stringMatch3, stringMatch4, n));
        }
        return arrayList;
    }

    private List<LinkMatch> findLinks(TransitionFigure transitionFigure) {
        ArrayList<LinkMatch> arrayList = new ArrayList<LinkMatch>();
        FigureEnumeration figureEnumeration = transitionFigure.children();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof CPNTextFigure)) continue;
            arrayList.addAll(this.findLinks((CPNTextFigure)figure));
        }
        return arrayList;
    }

    private static boolean hasParentTransitionFigure(CPNTextFigure cPNTextFigure) {
        return cPNTextFigure.parent() instanceof TransitionFigure;
    }
}

