/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.application.DrawApplication;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

class DrawingLoadServer
extends Thread {
    public static Logger logger = Logger.getLogger(DrawingLoadServer.class);
    private DrawApplication editor;
    private ServerSocket s = null;

    public DrawingLoadServer(DrawApplication drawApplication, int n) throws IOException {
        this.editor = drawApplication;
        logger.debug((Object)("Drawing Load Server setting up server socket at port " + n + " on loopback interface..."));
        this.s = new ServerSocket(n, 50, InetAddress.getByName(null));
        logger.debug((Object)("Drawing Load Server bound to: " + String.valueOf(this.s)));
    }

    @Override
    public void run() {
        logger.debug((Object)"Drawing Load Server waiting for parameters...");
        while (true) {
            Socket socket = null;
            try {
                socket = this.s.accept();
                logger.debug((Object)"Parameter server accepted client.");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                try {
                    String string;
                    do {
                        if ((string = bufferedReader.readLine()) == null) continue;
                        logger.debug((Object)("Received Parameter " + string));
                        this.editor.loadAndOpenCommandLineDrawings(new String[]{string});
                    } while (string != null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                logger.debug((Object)"Connection closed.");
                bufferedReader.close();
                socket.close();
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)("Drawing Load Server threw exception: " + String.valueOf(exception)));
                continue;
            }
            break;
        }
    }
}

