/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.Suggestion;
import de.renew.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class MethodSuggestion
extends Suggestion {
    public static Logger logger = Logger.getLogger(MethodSuggestion.class);
    private final Class[] types;
    private final Method method;
    private final String[] parameters;
    private final String callWithParameters;
    private final String attemptedMethod;

    public static List<MethodSuggestion> suggest(Class<?> clazz, String string, Class<?>[] classArray, int n) {
        Object object;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(JavaHelper.class.getName() + ": Class = " + clazz.toString()));
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = clazz.getMethods();
        if (methodArray.length != 0) {
            object = string;
            boolean bl = false;
            if (((String)object).endsWith("_")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
                bl = true;
            }
            if (methodArray.length > 20) {
                bl = true;
            }
            if (string.equals("_")) {
                bl = false;
            }
            for (Method method : methodArray) {
                int n2 = method.getModifiers();
                String string2 = method.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Name " + string2 + " pattern: " + (String)object));
                    logger.debug((Object)(JavaHelper.class.getName() + ": modifier for " + method.getName() + "= " + n2 + " " + !bl + string2.startsWith((String)object)));
                }
                if (bl && !string2.startsWith((String)object)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(JavaHelper.class.getName() + ": passed filter " + ((n & n2) != 0)));
                }
                if ((n & n2) == 0) continue;
                arrayList.add(method);
            }
        }
        object = new ArrayList();
        for (Method method : arrayList) {
            object.add(new MethodSuggestion(method, classArray, string));
        }
        Collections.sort(object);
        return object;
    }

    public MethodSuggestion(Method method, Class[] classArray, String string) {
        super(method.getName(), method.getReturnType().getSimpleName());
        this.method = method;
        this.types = classArray;
        this.attemptedMethod = string;
        Class<?>[] classArray2 = method.getParameterTypes();
        this.parameters = new String[classArray2.length];
        for (int i = 0; i < classArray2.length; ++i) {
            this.parameters[i] = classArray2[i].getSimpleName();
        }
        this.callWithParameters = this.name + "(" + StringUtil.join((String[])this.parameters, (String)", ") + ")";
    }

    @Override
    public String toString() {
        return "<html>" + this.getCallWithParameters() + " : " + this.getTypeName() + " <font color=gray>- " + this.method.getDeclaringClass().getSimpleName() + "</font></html>";
    }

    public String getCallWithParameters() {
        return this.callWithParameters;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?>[] getAttemptedTypes() {
        return this.types;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String getAttemptedMethod() {
        return this.attemptedMethod;
    }
}

