/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorExtension;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.NavigatorPlugin;
import de.renew.navigator.gui.DefaultFileTreeCellRenderer;
import de.renew.navigator.gui.NavigatorGuiImpl;
import de.renew.navigator.models.TreeElement;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class NavigatorGuiProxy
implements NavigatorGui {
    private final FilesystemController filesystem;
    private final NavigatorPlugin plugin;
    private NavigatorGuiImpl proxy;
    private final LinkedList<NavigatorExtension> tempExtensions;

    public NavigatorGuiProxy(FilesystemController filesystemController, NavigatorPlugin navigatorPlugin) {
        this.filesystem = filesystemController;
        this.plugin = navigatorPlugin;
        this.tempExtensions = new LinkedList();
    }

    @Override
    public void openWindow() {
        this.ensureProxyInitialized().openWindow();
    }

    @Override
    public void closeWindow() {
        this.ensureProxyInitialized().closeWindow();
        this.ensureProxyFreed();
    }

    @Override
    public List<NavigatorExtension> getExtensions() {
        if (this.proxy == null) {
            return this.tempExtensions;
        }
        return this.proxy.getExtensions();
    }

    @Override
    public void addExtension(NavigatorExtension navigatorExtension) {
        if (this.proxy == null) {
            this.tempExtensions.add(navigatorExtension);
            return;
        }
        this.proxy.addExtension(navigatorExtension);
    }

    @Override
    public boolean removeExtension(NavigatorExtension navigatorExtension) {
        if (this.proxy == null) {
            return this.tempExtensions.remove(navigatorExtension);
        }
        return this.proxy.removeExtension(navigatorExtension);
    }

    @Override
    public DefaultFileTreeCellRenderer getTreeCellRenderer() {
        return this.ensureProxyInitialized().getTreeCellRenderer();
    }

    @Override
    public JTree getTree() {
        return this.ensureProxyInitialized().getTree();
    }

    @Override
    public DefaultMutableTreeNode getRootNode() {
        return this.ensureProxyInitialized().getRootNode();
    }

    @Override
    public void collapseAll() {
        this.ensureProxyInitialized().collapseAll();
    }

    @Override
    public void expand() {
        this.ensureProxyInitialized().expand();
    }

    @Override
    public void removeSelectedNodes() {
        this.ensureProxyInitialized().removeSelectedNodes();
    }

    @Override
    public List<TreeElement> getSelectedElements() {
        return this.ensureProxyInitialized().getSelectedElements();
    }

    private NavigatorGuiImpl ensureProxyInitialized() {
        if (this.proxy != null) {
            return this.proxy;
        }
        this.proxy = new NavigatorGuiImpl(this.filesystem, this.plugin);
        for (NavigatorExtension navigatorExtension : this.tempExtensions) {
            this.proxy.addExtension(navigatorExtension);
        }
        this.tempExtensions.clear();
        return this.proxy;
    }

    private void ensureProxyFreed() {
        if (this.proxy == null) {
            return;
        }
        for (NavigatorExtension navigatorExtension : this.proxy.getExtensions()) {
            this.tempExtensions.add(navigatorExtension);
        }
        this.proxy.dispose();
        this.proxy = null;
    }
}

