/*
 * Decompiled with CFR 0.152.
 */
package de.renew.pd.generating;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.io.SimpleFileFilter;
import de.renew.pd.PluginDevelopmentPlugin;
import de.renew.pd.generating.PluginGenerator;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class StandardPluginGenerator
implements PluginGenerator {
    private static String STANDARD_TEMPLATE_FOLDER = "de/renew/pd/templates/standard/";
    private static final String SOURCE_PATH_PREFIX = "src/de/renew/";
    public static Logger logger = Logger.getLogger(StandardPluginGenerator.class);
    private String dirRenewCheckout = "";
    protected VelocityEngine ve;
    private URL location;
    protected String templateFolder = STANDARD_TEMPLATE_FOLDER;

    public StandardPluginGenerator() {
        this.ve = new VelocityEngine();
        this.ve.setProperty("resource.loader", (Object)"file, class");
        this.ve.setProperty("class.resource.loader.description", (Object)"Velocity Classpath Resource Loader");
        this.ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            this.ve.init();
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        this.location = PluginDevelopmentPlugin.getLocation();
        this.dirRenewCheckout = new File(this.location.getPath()).getParentFile().getParentFile().getParentFile().getParent();
    }

    @Override
    public void generate() {
        String string;
        PLGFileFilter pLGFileFilter;
        JFileChooser jFileChooser;
        int n;
        logger.info((Object)(StandardPluginGenerator.class.getName() + "Root dir is: " + this.dirRenewCheckout));
        String string2 = "test";
        File file = new File(this.dirRenewCheckout + File.separator + "develop" + File.separator + string2 + ".plg");
        File file2 = null;
        Properties properties = new Properties();
        String string3 = null;
        boolean bl = false;
        if (file.exists()) {
            n = JOptionPane.showConfirmDialog(this.editorFrame(), "Found 'test' in Renew/develop.\ndo you want to use this file as your configuration file?");
            logger.info((Object)("PLG file found. Using default config file: " + string2 + ".plg"));
            if (n == 0) {
                file2 = file;
                bl = true;
            }
        }
        n = 0;
        if (!file.exists() || !bl) {
            jFileChooser = new JFileChooser(this.dirRenewCheckout);
            pLGFileFilter = new PLGFileFilter();
            jFileChooser.setFileFilter((FileFilter)((Object)pLGFileFilter));
            jFileChooser.setDialogTitle("Choose a Plugin Setup Property File");
            int n2 = jFileChooser.showOpenDialog(DrawPlugin.getGui().getFrame());
            if (n2 == 0) {
                file2 = jFileChooser.getSelectedFile();
            } else {
                string = JOptionPane.showInputDialog("You have not chosen a *.plg file.\n If you wish to create a Plugin without a plg file you need to provide a Name.");
                if (string == null || string.equals("")) {
                    logger.info((Object)(StandardPluginGenerator.class.getName() + ": Canceled"));
                    return;
                }
                string3 = string;
                n = 1;
                properties.put("appName", string3);
            }
        }
        if (n == 0) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                properties.load(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (file2 != null && !properties.containsKey("appName") && string3 != null && !string3.equals("")) {
            logger.info((Object)"You must specify the porperty \"appName\".");
            JOptionPane.showMessageDialog(this.editorFrame(), "Please set the proptery 'appName' in " + file2.getName());
            return;
        }
        string3 = properties.getProperty("appName");
        jFileChooser = PluginManager.getInstance();
        pLGFileFilter = jFileChooser.getPluginByName("Renew Plugin Development");
        PluginProperties pluginProperties = pLGFileFilter.getProperties();
        string = pluginProperties.getVersion();
        properties.setProperty("pdversion", string);
        logger.info((Object)("PluginDevelopment Plugin version: " + properties.getProperty("pdversion")));
        JFileChooser jFileChooser2 = new JFileChooser(this.dirRenewCheckout + File.separator + "..");
        jFileChooser2.setSelectedFile(new File("Renew"));
        jFileChooser2.setFileSelectionMode(1);
        jFileChooser2.setDialogType(2);
        jFileChooser2.setDialogTitle("Select Renew Plugin Source Folder.");
        jFileChooser2.setToolTipText("If you do not know better choose the Renew folder.");
        int n3 = jFileChooser2.showDialog(this.editorFrame(), "Choose Directory");
        if (n3 != 0) {
            logger.info((Object)"User abort.");
            return;
        }
        File file3 = jFileChooser2.getSelectedFile();
        if (!new File(file3, "ant").exists()) {
            logger.info((Object)"Not a valid Root for Plugins.");
            return;
        }
        String string4 = file3.getAbsolutePath();
        if (new File(string4 + File.separator + string3).exists()) {
            logger.info((Object)("Plugin as plugin named " + string3 + " already exists. Please erase and try again."));
            return;
        }
        this.createFolders(string4, string3);
        this.createFilesFromTemplates(string4, properties);
    }

    private JFrame editorFrame() {
        return DrawPlugin.getGui().getFrame();
    }

    protected void createFilesFromTemplates(String string, Properties properties) {
        try {
            Context context = this.getContextFromProperties(properties);
            context.put("generic-description", (Object)"This is the generated desctiption for this plugin.");
            context.put("generic-name", (Object)properties.getProperty("appName").toLowerCase());
            context.put("smallAppName", (Object)properties.getProperty("appName").toLowerCase());
            this.createFile(this.ve, context, string, "", "build.xml", null);
            this.createFile(this.ve, context, string, "etc", "plugin.cfg", null);
            this.createFile(this.ve, context, string, SOURCE_PATH_PREFIX + File.separator + String.valueOf(context.get("smallAppName")), "PluginClass.java", properties.getProperty("appName") + "Plugin.java");
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            logger.error((Object)resourceNotFoundException.getMessage());
            logger.debug((Object)resourceNotFoundException.getStackTrace());
        }
        catch (ParseErrorException parseErrorException) {
            logger.error((Object)parseErrorException.getMessage());
            logger.debug((Object)parseErrorException.getStackTrace());
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            logger.debug((Object)exception.getStackTrace());
        }
    }

    protected Context getContextFromProperties(Properties properties) {
        VelocityContext velocityContext = new VelocityContext();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            velocityContext.put(string, (Object)properties.getProperty(string));
        }
        return velocityContext;
    }

    protected void createFile(VelocityEngine velocityEngine, Context context, String string, String string2, String string3, String string4) throws ResourceNotFoundException, ParseErrorException, Exception, IOException, MethodInvocationException {
        String string5 = this.templateFolder + string3 + ".vm";
        logger.debug((Object)("PluginGenerator: Tamplates taken from: " + string5));
        Template template = velocityEngine.getTemplate(string5);
        String string6 = string + File.separator + String.valueOf(context.get("appName"));
        logger.debug((Object)("PluginGenerator: Destfoldername " + string6));
        if (string2 != null && !string2.equals("")) {
            string6 = string6 + File.separator + string2;
            new File(string6).mkdirs();
        }
        String string7 = string4 == null || "".equals(string4) ? string6 + File.separator + string3 : string6 + File.separator + string4;
        File file = new File(string7);
        logger.debug((Object)("PluginGenerator: ----> writing: " + string7));
        FileWriter fileWriter = new FileWriter(file);
        template.merge(context, (Writer)fileWriter);
        fileWriter.close();
    }

    protected void createFolders(String string, String string2) {
        String string3 = SOURCE_PATH_PREFIX + File.separator + string2.toLowerCase();
        File file = new File(string + File.separator + string2 + File.separator + string3);
        file.mkdirs();
    }

    class PLGFileFilter
    extends SimpleFileFilter {
        public PLGFileFilter() {
            this.setExtension("plg");
            this.setDescription("Plugin Configuration (*.plg)");
        }
    }
}

