/*
 * Decompiled with CFR 0.152.
 */
package de.renew.call;

import de.renew.net.NetInstance;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Hashtable;

class StubGenerator {
    private static String USAGE_MESSAGE = "Required arguments: [-d PATH] CLASS NET {[+]INTERFACE}\n\nCLASS must be a fully qualified class name.\nNET must be a valid net identifier.\nIf an INTERFACE in the list is preceeded by '+',\nits void methods will be designated as 'break void'.\n\nThe resulting stub file will be placed in the directory\nthat corresponds to the package of CLASS, if any.\nIf the -d option if specified, PATH is taken as the root directory\nfor the target stub file, otherwise the current directory.\nNo directory will be created. No files will be overwritten.\n";

    StubGenerator() {
    }

    static String complexForPrimitive(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return "Boolean";
        }
        if (clazz == Byte.TYPE) {
            return "Byte";
        }
        if (clazz == Character.TYPE) {
            return "Character";
        }
        if (clazz == Short.TYPE) {
            return "Short";
        }
        if (clazz == Integer.TYPE) {
            return "Integer";
        }
        if (clazz == Long.TYPE) {
            return "Long";
        }
        if (clazz == Float.TYPE) {
            return "Float";
        }
        if (clazz == Double.TYPE) {
            return "Double";
        }
        return "";
    }

    static String getTypeName(Class<?> clazz) {
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        while (n > 0) {
            stringBuffer.append("[]");
            --n;
        }
        return stringBuffer.toString();
    }

    static String makeSignature(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(StubGenerator.getTypeName(method.getReturnType()));
        stringBuffer.append(" ");
        stringBuffer.append(method.getName());
        stringBuffer.append("(");
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StubGenerator.getTypeName(classArray[i]));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static void outputMethod(Method method, boolean bl, PrintWriter printWriter) {
        int n;
        Class<?>[] classArray = method.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer("  ");
        if (method.getReturnType() == Void.TYPE && bl) {
            stringBuffer.append("break ");
        }
        stringBuffer.append(StubGenerator.getTypeName(method.getReturnType()));
        stringBuffer.append(" ");
        stringBuffer.append(method.getName());
        stringBuffer.append("(");
        for (n = 0; n < classArray.length; ++n) {
            if (n > 0) {
                printWriter.println(stringBuffer);
                stringBuffer = new StringBuffer();
                stringBuffer.append("    ");
            }
            String string = StubGenerator.getTypeName(classArray[n]) + " arg" + n;
            stringBuffer.append(string);
            if (n >= classArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        if (classArray.length > 1) {
            printWriter.println(stringBuffer);
            stringBuffer = new StringBuffer();
            stringBuffer.append(" ");
        }
        stringBuffer.append(" {");
        printWriter.println(stringBuffer);
        stringBuffer = new StringBuffer("    this:");
        stringBuffer.append(method.getName());
        stringBuffer.append("(instance");
        for (n = 0; n < classArray.length; ++n) {
            stringBuffer.append(",arg" + n);
        }
        stringBuffer.append(");");
        printWriter.println(stringBuffer);
        if (method.getReturnType() == Void.TYPE) {
            printWriter.println("    this:result(instance);");
        } else {
            printWriter.println("    this:result(instance,return);");
        }
        printWriter.println("  }");
    }

    public static void main(String[] stringArray) {
        String string;
        String string2;
        File file;
        if (stringArray.length < 2 || "-d".equals(stringArray[0]) && stringArray.length < 4) {
            System.err.println(USAGE_MESSAGE);
            System.exit(0);
        }
        int n = 0;
        Object object = "";
        if ("-d".equals(stringArray[0])) {
            int n2 = ++n;
            ++n;
            object = stringArray[n2].substring(2).trim();
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
        }
        if ((file = new File(string2 = (String)object + (string = stringArray[n++]).replace('.', File.separatorChar) + ".stub")).exists()) {
            System.err.println("Target file " + string2 + " already exists. Aborting.");
        }
        String string3 = stringArray[n++];
        PrintWriter printWriter = null;
        try {
            Method[] methodArray;
            GenericDeclaration genericDeclaration;
            int n3;
            String string4;
            printWriter = new PrintWriter(new FileWriter(file));
            boolean[] blArray = new boolean[stringArray.length - n];
            String[] stringArray2 = new String[stringArray.length - n];
            int n4 = 0;
            while (n < stringArray.length) {
                blArray[n4] = stringArray[n].charAt(0) == '+';
                stringArray2[n4] = blArray[n4] ? stringArray[n].substring(1) : stringArray[n];
                ++n;
                ++n4;
            }
            n4 = string.lastIndexOf(".");
            if (n4 > 0) {
                printWriter.println("package " + string.substring(0, n4) + ";");
                string4 = string.substring(n4 + 1);
            } else {
                string4 = string;
            }
            int n5 = stringArray2.length;
            printWriter.println("class " + string4 + " for net " + string3);
            if (n5 > 0) {
                printWriter.println("implements");
                for (int i = 0; i < n5; ++i) {
                    if (i + 1 < n5) {
                        printWriter.println("  " + stringArray2[i] + ",");
                        continue;
                    }
                    printWriter.println("  " + stringArray2[i]);
                }
            }
            printWriter.println("{");
            Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>();
            Method[] methodArray2 = NetInstance.class.getMethods();
            for (n3 = 0; n3 < methodArray2.length; ++n3) {
                genericDeclaration = methodArray2[n3];
                methodArray = StubGenerator.makeSignature((Method)genericDeclaration);
                hashtable.put(methodArray, Boolean.FALSE);
            }
            for (n3 = 0; n3 < n5; ++n3) {
                try {
                    genericDeclaration = Class.forName(stringArray2[n3]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException.toString());
                }
                if (!((Class)genericDeclaration).isInterface()) {
                    throw new RuntimeException("Not an interface: " + stringArray2[n3]);
                }
                methodArray = ((Class)genericDeclaration).getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    Method method = methodArray[i];
                    String string5 = StubGenerator.makeSignature(method);
                    if (!hashtable.containsKey(string5)) {
                        hashtable.put(string5, new Boolean(blArray[n3]));
                        StubGenerator.outputMethod(method, blArray[n3], printWriter);
                        continue;
                    }
                    Boolean bl = (Boolean)hashtable.get(string5);
                    if (method.getReturnType() != Void.TYPE || !(bl ^ blArray[n3])) continue;
                    throw new RuntimeException("Method requested twice, but only once as break void. " + string5);
                }
            }
            printWriter.println("}");
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println("An error occurred during the creation of the stub file.");
            System.err.println(exception.getMessage());
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception3) {
                System.err.println("Could not remove broken file " + string2 + ".");
            }
        }
    }
}

