/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

public class RandomBag {
    private Object[] elements = new Object[8];
    private int size = 0;

    public int size() {
        return this.size;
    }

    private void setCapacity(int n) {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, 0, objectArray, 0, this.size);
        this.elements = objectArray;
    }

    private void ensureCapacity(int n) {
        if (n > this.elements.length) {
            if (n < 2 * this.elements.length) {
                n = 2 * this.elements.length;
            }
            this.setCapacity(n);
        }
    }

    private void limitCapacity() {
        if (this.size >= 8 && this.size * 4 < this.elements.length) {
            this.setCapacity(this.size * 2);
        }
    }

    public void insert(Object object) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.size++] = object;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object extract() {
        if (this.isEmpty()) {
            return null;
        }
        Object object = this.elements[this.size - 1];
        this.elements[this.size - 1] = null;
        --this.size;
        this.limitCapacity();
        return object;
    }
}

