/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.ClassSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class MultiPropertyResourceBundle
extends ResourceBundle {
    private ResourceBundle bundle;

    public MultiPropertyResourceBundle(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public MultiPropertyResourceBundle(String string) {
        this(string, Locale.getDefault());
    }

    public MultiPropertyResourceBundle(String string, Locale locale) {
        this(string, locale, ClassSource.getClassLoader());
    }

    public MultiPropertyResourceBundle(String string, Locale locale, ClassLoader classLoader) {
        this.bundle = ResourceBundle.getBundle(string, locale, classLoader);
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.bundle.getKeys();
    }

    @Override
    public Locale getLocale() {
        return this.bundle.getLocale();
    }

    @Override
    protected Object handleGetObject(String string) throws MissingResourceException {
        String string2 = this.bundle.getString(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((String)arrayList.get(i)).trim();
        }
        return stringArray;
    }

    @Override
    protected void setParent(ResourceBundle resourceBundle) {
        throw new UnsupportedOperationException("Multi property resource bundles do not support parents");
    }
}

