/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.common;

import de.renew.engine.searcher.AbstractOccurrence;
import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.TransitionInstance;
import de.renew.unify.Impossible;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CompositeOccurrence
extends AbstractOccurrence {
    private List<Occurrence> occurrences = new ArrayList<Occurrence>();

    public CompositeOccurrence(TransitionInstance transitionInstance) {
        super(transitionInstance);
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
    }

    public void addOccurrence(Occurrence occurrence) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.occurrences.add(occurrence);
    }

    public void addOccurrences(Collection<Occurrence> collection) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.occurrences.addAll(collection);
    }

    @Override
    public Collection<Binder> makeBinders(Searcher searcher) throws Impossible {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ArrayList<Binder> arrayList = new ArrayList<Binder>();
        Iterator<Occurrence> iterator = this.occurrences.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(iterator.next().makeBinders(searcher));
        }
        return arrayList;
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier variableMapperCopier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ArrayList<Executable> arrayList = new ArrayList<Executable>();
        Iterator<Occurrence> iterator = this.occurrences.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(iterator.next().makeExecutables(variableMapperCopier));
        }
        return arrayList;
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier variableMapperCopier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return null;
    }
}

