/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.inline;

import de.renew.refactoring.inline.InlineStepWithListener;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class PopupMenuStep<T>
extends InlineStepWithListener {
    private static Logger logger = Logger.getLogger(PopupMenuStep.class);
    private JPopupMenu _menu;
    private Map<JMenuItem, T> _menuItems = new HashMap<JMenuItem, T>();

    public PopupMenuStep(Container container, Point point, List<T> list) {
        this._menu = new JPopupMenu();
        this.addEntries(list);
        this._menu.addPopupMenuListener(this.popupMenuListener());
        this._menu.show(container, point.x, point.y);
    }

    private void addEntries(List<T> list) {
        for (T t : list) {
            JMenuItem jMenuItem = new JMenuItem(this.titleForEntry(t));
            ActionListener actionListener = this.actionListenerForEntry(t);
            jMenuItem.addActionListener(this.makeOuterListener(actionListener));
            this._menu.add(jMenuItem);
            this._menuItems.put(jMenuItem, t);
        }
    }

    private ActionListener makeOuterListener(final ActionListener actionListener) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionListener != null) {
                    actionListener.actionPerformed(actionEvent);
                }
                PopupMenuStep.this.informListenersFinished();
            }
        };
    }

    public T getEntryForMenuItem(JMenuItem jMenuItem) {
        return this._menuItems.get(jMenuItem);
    }

    public ActionListener actionListenerForEntry(T t) {
        return null;
    }

    public String titleForEntry(T t) {
        return t.toString();
    }

    private PopupMenuListener popupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                PopupMenuStep.this.informListenersCancelled();
            }
        };
    }
}

