/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.inline;

import de.renew.refactoring.inline.InlineController;
import de.renew.refactoring.inline.InlineListener;
import de.renew.refactoring.inline.InlineStep;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class InlineControllerWithListener
implements InlineController {
    private static Logger logger = Logger.getLogger(InlineControllerWithListener.class);
    private Set<InlineListener> _listeners = new HashSet<InlineListener>();

    @Override
    public abstract InlineStep nextStep();

    @Override
    public void addListener(InlineListener inlineListener) {
        this._listeners.add(inlineListener);
    }

    @Override
    public void removeListener(InlineListener inlineListener) {
        this._listeners.remove(inlineListener);
    }

    protected Set<InlineListener> getListeners() {
        return this._listeners;
    }

    protected void informListenersFinished() {
        for (InlineListener inlineListener : this.getListeners()) {
            inlineListener.inlineFinished();
        }
    }
}

