/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.util.ColorMap;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.DoubleArcConnection;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.HollowDoubleArcConnection;
import de.renew.gui.InhibitorConnection;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowDeclarationNode;
import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNode;
import de.renew.shadow.ShadowTransition;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Hashtable;

class ShadowNetRenderer {
    CPNDrawing drawing = new CPNDrawing();
    private Hashtable<ShadowInscribable, ParentFigure> lookup = new Hashtable();
    private Point loc = new Point(100, 20);

    ShadowNetRenderer(ShadowNet shadowNet) {
        this.render(shadowNet);
    }

    private void render(ShadowNet shadowNet) {
        this.drawing.setName(shadowNet.getName());
        for (Object e : shadowNet.elements()) {
            if (e instanceof ShadowNode) {
                this.renderNode((ShadowNode)e);
            }
            if (!(e instanceof ShadowDeclarationNode)) continue;
            this.renderDeclarationNode((ShadowDeclarationNode)e);
        }
        for (Object e : shadowNet.elements()) {
            if (!(e instanceof ShadowArc)) continue;
            this.renderArc((ShadowArc)e);
        }
        for (Object e : shadowNet.elements()) {
            if (!(e instanceof ShadowInscription)) continue;
            this.renderInscription((ShadowInscription)e);
        }
    }

    private void renderDeclarationNode(ShadowDeclarationNode shadowDeclarationNode) {
        DeclarationFigure declarationFigure = new DeclarationFigure();
        declarationFigure.setText(shadowDeclarationNode.inscr);
        this.drawing.add(declarationFigure);
    }

    private void renderNode(ShadowNode shadowNode) {
        Object object;
        Dimension dimension = null;
        FigureWithHighlight figureWithHighlight = null;
        if (shadowNode instanceof ShadowTransition) {
            figureWithHighlight = new TransitionFigure();
            dimension = TransitionFigure.defaultDimension();
        } else {
            figureWithHighlight = new PlaceFigure();
            dimension = PlaceFigure.defaultDimension();
        }
        this.drawing.add((Figure)figureWithHighlight);
        if (shadowNode.getName() != null) {
            object = new CPNTextFigure(2);
            object.setText(shadowNode.getName());
            int n = object.displayBox().width;
            if (n + 8 > dimension.width) {
                dimension.width = n + 8;
            }
            this.drawing.add((Figure)object);
            object.setParent((ParentFigure)figureWithHighlight);
        }
        object = new Point(dimension.width, dimension.height);
        figureWithHighlight.displayBox(new Point(), (Point)object);
        figureWithHighlight.moveBy(this.loc.x, this.loc.y);
        this.lookup.put((ShadowInscribable)shadowNode, (ParentFigure)figureWithHighlight);
        figureWithHighlight.setAttribute("TraceMode", new Boolean(shadowNode.getTrace()));
    }

    private void renderArc(ShadowArc shadowArc) {
        Figure figure;
        int n = shadowArc.shadowArcType;
        Figure figure2 = (Figure)this.lookup.get(shadowArc.place);
        Figure figure3 = (Figure)this.lookup.get(shadowArc.transition);
        if (!shadowArc.placeToTransition) {
            figure = figure2;
            figure2 = figure3;
            figure3 = figure;
        }
        figure = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                figure = new ArcConnection(n);
                break;
            }
            case 3: {
                figure = new InhibitorConnection();
                break;
            }
            case 4: {
                figure = new DoubleArcConnection();
                break;
            }
            case 5: {
                figure = new HollowDoubleArcConnection();
                break;
            }
            default: {
                throw new RuntimeException("Bad shadow arc type.");
            }
        }
        figure.startPoint(0, 0);
        figure.endPoint(0, 0);
        this.drawing.add(figure);
        this.lookup.put((ShadowInscribable)shadowArc, (ParentFigure)figure);
        figure.connectStart(figure2.connectorAt(0, 0));
        figure.connectEnd(figure3.connectorAt(0, 0));
        figure.updateConnection();
        figure.setAttribute("TraceMode", new Boolean(shadowArc.getTrace()));
    }

    private void renderInscription(ShadowInscription shadowInscription) {
        CPNTextFigure cPNTextFigure = new CPNTextFigure(1);
        cPNTextFigure.setText(shadowInscription.inscr);
        ParentFigure parentFigure = this.lookup.get(shadowInscription.inscribable);
        this.drawing.add(cPNTextFigure);
        cPNTextFigure.setParent(parentFigure);
        cPNTextFigure.setAttribute("TraceMode", new Boolean(shadowInscription.getTrace()));
        if (parentFigure instanceof ArcConnection) {
            cPNTextFigure.setAttribute("FillColor", ColorMap.BACKGROUND);
        }
    }
}

