/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class JComponentCellEditor
implements TableCellEditor,
TreeCellEditor,
Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected JComponent editorComponent = null;
    protected JComponent container = null;
    protected TableCellEditor tableCellEditor = null;
    protected TreeCellEditor treeCellEditor = null;

    public JComponentCellEditor(TableCellEditor tableCellEditor, TreeCellEditor treeCellEditor) {
        this.tableCellEditor = tableCellEditor;
        this.treeCellEditor = treeCellEditor;
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorComponent;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        if (this.editorComponent != null && eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getID() == 501) {
            Component component = SwingUtilities.getDeepestComponentAt(this.editorComponent, 3, 3);
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            MouseEvent mouseEvent2 = new MouseEvent(component, 502, mouseEvent.getWhen() + 100000L, mouseEvent.getModifiers(), 3, 3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            component.dispatchEvent(mouseEvent2);
            mouseEvent2 = new MouseEvent(component, 500, mouseEvent.getWhen() + 100001L, mouseEvent.getModifiers(), 3, 3, 1, mouseEvent.isPopupTrigger());
            component.dispatchEvent(mouseEvent2);
        }
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        if (object instanceof JComponent) {
            this.editorComponent = (JComponent)object;
            this.container = jTree;
            return this.editorComponent;
        }
        return this.treeCellEditor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object instanceof JComponent) {
            this.editorComponent = (JComponent)object;
            this.container = jTable;
            return this.editorComponent;
        }
        return this.tableCellEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }
}

