/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class Types {
    public static Logger logger = Logger.getLogger(Types.class);
    public static final Class<?> UNTYPED = new Object(){}.getClass();
    public static final String[] NOPACKAGES = null;
    public static final String[] ALLPACKAGES = new String[0];
    private static int assertionCount = 0;

    private Types() {
    }

    public static Class<?> objectify(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }

    public static boolean isFinal(Class<?> clazz) {
        if (clazz == null || clazz == UNTYPED) {
            return true;
        }
        return (clazz.getModifiers() & 0x10) != 0;
    }

    public static boolean allowsIdentityConversion(Class<?> clazz, Class<?> clazz2) {
        return clazz2 == clazz;
    }

    public static boolean allowsPrimitiveWidening(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null || clazz2 == UNTYPED) {
            return false;
        }
        if (clazz2 == clazz) {
            return false;
        }
        if (clazz == null || clazz == UNTYPED) {
            return false;
        }
        if (!clazz2.isPrimitive() || !clazz.isPrimitive()) {
            return false;
        }
        if (clazz2 == Void.TYPE || clazz == Void.TYPE) {
            return false;
        }
        if (clazz2 == Boolean.TYPE || clazz == Boolean.TYPE) {
            return false;
        }
        if (clazz2 == Character.TYPE) {
            return false;
        }
        if (clazz2 == Double.TYPE) {
            return true;
        }
        if (clazz == Double.TYPE) {
            return false;
        }
        if (clazz2 == Float.TYPE) {
            return true;
        }
        if (clazz == Float.TYPE) {
            return false;
        }
        if (clazz2 == Long.TYPE) {
            return true;
        }
        if (clazz == Long.TYPE) {
            return false;
        }
        if (clazz2 == Integer.TYPE) {
            return true;
        }
        return clazz == Byte.TYPE;
    }

    public static boolean allowsReferenceWidening(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null || clazz2 == UNTYPED) {
            return false;
        }
        if (clazz2 == clazz) {
            return false;
        }
        if (clazz == UNTYPED) {
            return false;
        }
        if (clazz == null) {
            return !clazz2.isPrimitive();
        }
        if (clazz2.isPrimitive() || clazz.isPrimitive()) {
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean allowsLosslessWidening(Class<?> clazz, Class<?> clazz2) {
        if (!Types.allowsWideningConversion(clazz, clazz2)) {
            return false;
        }
        return !(clazz == Integer.TYPE && clazz2 == Float.TYPE || clazz == Long.TYPE && clazz2 == Float.TYPE) && (clazz != Long.TYPE || clazz2 != Double.TYPE);
    }

    public static boolean allowsWideningConversion(Class<?> clazz, Class<?> clazz2) {
        return Types.allowsIdentityConversion(clazz, clazz2) || Types.allowsPrimitiveWidening(clazz, clazz2) || Types.allowsReferenceWidening(clazz, clazz2);
    }

    public static boolean allowsWideningConversion(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (Types.allowsWideningConversion(classArray[i], classArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allowsCast(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null || clazz2 == UNTYPED) {
            return false;
        }
        if (clazz == null) {
            return !clazz2.isPrimitive();
        }
        if (clazz == UNTYPED) {
            return true;
        }
        while (clazz.isArray() && clazz2.isArray()) {
            clazz = clazz.getComponentType();
            clazz2 = clazz2.getComponentType();
        }
        if (Types.allowsIdentityConversion(clazz, clazz2)) {
            return true;
        }
        if (clazz2.isPrimitive() || clazz.isPrimitive()) {
            if (!clazz2.isPrimitive() || !clazz.isPrimitive()) {
                return false;
            }
            return clazz2 != Boolean.TYPE && clazz != Boolean.TYPE && clazz2 != Void.TYPE && clazz != Void.TYPE;
        }
        if (Types.allowsReferenceWidening(clazz, clazz2)) {
            return true;
        }
        if (Types.allowsReferenceWidening(clazz2, clazz)) {
            return true;
        }
        if (Types.isFinal(clazz)) {
            return false;
        }
        if (Types.isFinal(clazz2)) {
            return false;
        }
        if (!clazz2.isInterface() && !clazz.isInterface()) {
            return false;
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            try {
                Method method = clazz2.getMethod(methodArray[i].getName(), methodArray[i].getParameterTypes());
                if (method.getReturnType() == methodArray[i].getReturnType()) continue;
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static Class<?> typify(Class<?> clazz) {
        if (clazz == Void.class) {
            return Void.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        throw new RuntimeException("Cannot make primitive type from " + String.valueOf(clazz));
    }

    public static String typeToString(Class<?> clazz) {
        return Types.typeToString(clazz, ALLPACKAGES);
    }

    public static String typeToString(Class<?> clazz, String[] stringArray) {
        if (clazz == UNTYPED) {
            return "untyped";
        }
        if (clazz == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            stringBuffer.append("[]");
            clazz = clazz.getComponentType();
        }
        String string = clazz.getName();
        String string2 = Types.getPureName(string);
        String string3 = null;
        if (stringArray != null) {
            string3 = Types.getPackageName(string);
            for (int i = 0; string3 != null && i < stringArray.length; ++i) {
                if (!string3.equals(stringArray[i])) continue;
                string3 = null;
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (string3 != null) {
            stringBuffer2.append(string3).append('.');
        }
        return stringBuffer2.append(string2).append(stringBuffer).toString();
    }

    public static String getPackageName(Class<?> clazz) {
        return Types.getPackageName(Types.typeToString(clazz, ALLPACKAGES));
    }

    public static String getPureName(Class<?> clazz) {
        return Types.getPureName(Types.typeToString(clazz, ALLPACKAGES));
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getPureName(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static void assertTrue(boolean bl) {
        ++assertionCount;
        if (!bl) {
            logger.error((Object)("Assertion " + assertionCount + " failed."));
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Types.assertTrue(!Types.allowsCast(Integer.class, Integer.TYPE));
        Types.assertTrue(Types.allowsCast(null, Integer.class));
        Types.assertTrue(!Types.allowsCast(null, Integer.TYPE));
        Types.assertTrue(Types.allowsCast(Object.class, Integer.class));
        Types.assertTrue(Types.allowsCast(Object.class, Object[].class));
        Types.assertTrue(Types.allowsCast(Cloneable.class, Object[].class));
        Types.assertTrue(!Types.allowsCast(String.class, Number.class));
        Types.assertTrue(!Types.allowsCast(String.class, Number.class));
        Types.assertTrue("int[]".equals(Types.typeToString(int[].class, ALLPACKAGES)));
        Types.assertTrue("int[]".equals(Types.typeToString(int[].class, NOPACKAGES)));
        Types.assertTrue("java.lang.Object[]".equals(Types.typeToString(Object[].class, ALLPACKAGES)));
        Types.assertTrue("Object[]".equals(Types.typeToString(Object[].class, NOPACKAGES)));
        Types.assertTrue("java.lang.Integer".equals(Types.typeToString(Integer.class, new String[]{"java.lung"})));
        Types.assertTrue("java.lang.Integer".equals(Types.typeToString(Integer.class)));
        Types.assertTrue("Integer".equals(Types.typeToString(Integer.class, new String[]{"java.lang"})));
    }
}

