/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.remote.NetAccessor;
import de.renew.remote.ObjectAccessorImpl;
import de.renew.remote.PlaceAccessor;
import de.renew.remote.PlaceAccessorImpl;
import de.renew.remote.TransitionAccessor;
import de.renew.remote.TransitionAccessorImpl;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class NetAccessorImpl
extends ObjectAccessorImpl
implements NetAccessor {
    public static Logger logger = Logger.getLogger(NetAccessorImpl.class);

    public NetAccessorImpl(Net net, SimulationEnvironment simulationEnvironment) throws RemoteException {
        super(net, simulationEnvironment);
    }

    @Override
    public String getName() throws RemoteException {
        return ((Net)this.object).getName();
    }

    @Override
    public NetElementID[] getPlaceIDs() throws RemoteException {
        final Net net = (Net)this.object;
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<NetElementID[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetElementID[] call() throws Exception {
                Net net2 = net;
                synchronized (net2) {
                    NetElementID[] netElementIDArray = new NetElementID[((Net)NetAccessorImpl.this.object).placeCount()];
                    Iterator iterator = net.places().iterator();
                    for (int i = 0; i < netElementIDArray.length; ++i) {
                        netElementIDArray[i] = ((Place)iterator.next()).getID();
                    }
                    return netElementIDArray;
                }
            }
        });
        try {
            return (NetElementID[])future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public PlaceAccessor getPlace(final NetElementID netElementID) throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<PlaceAccessor>(){

            @Override
            public PlaceAccessor call() throws Exception {
                Place place = ((Net)NetAccessorImpl.this.object).getPlaceWithID(netElementID);
                if (place == null) {
                    return null;
                }
                return new PlaceAccessorImpl(place, NetAccessorImpl.this.getEnvironment());
            }
        });
        try {
            return (PlaceAccessor)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public NetElementID[] getTransitionIDs() throws RemoteException {
        final Net net = (Net)this.object;
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<NetElementID[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetElementID[] call() throws Exception {
                Net net2 = net;
                synchronized (net2) {
                    NetElementID[] netElementIDArray = new NetElementID[((Net)NetAccessorImpl.this.object).transitionCount()];
                    Iterator iterator = net.transitions().iterator();
                    for (int i = 0; i < netElementIDArray.length; ++i) {
                        netElementIDArray[i] = ((Transition)iterator.next()).getID();
                    }
                    return netElementIDArray;
                }
            }
        });
        try {
            return (NetElementID[])future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public TransitionAccessor getTransition(final NetElementID netElementID) throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<TransitionAccessor>(){

            @Override
            public TransitionAccessor call() throws Exception {
                Transition transition = ((Net)NetAccessorImpl.this.object).getTransitionWithID(netElementID);
                if (transition == null) {
                    return null;
                }
                return new TransitionAccessorImpl(transition, NetAccessorImpl.this.getEnvironment());
            }
        });
        try {
            return (TransitionAccessor)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }
}

