/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.ConfigureRemoteAccessTab;
import de.renew.gui.ConfigureSimulationTabController;
import de.renew.plugin.PropertyHelper;
import de.renew.remote.RemoteExtension;
import java.awt.Component;
import java.util.Properties;
import org.apache.log4j.Logger;

class ConfigureRemoteAccessController
implements ConfigureSimulationTabController {
    public static Logger logger = Logger.getLogger(ConfigureRemoteAccessController.class);
    private ConfigureRemoteAccessTab tab = new ConfigureRemoteAccessTab(this);

    @Override
    public Component getTab() {
        return this.tab;
    }

    @Override
    public void commitTab(Properties properties) {
        boolean bl = this.tab.getRemoteEnabled();
        properties.setProperty("de.renew.remote.enable", Boolean.toString(bl));
        String string = this.tab.getPublicName().trim();
        if (string.equals("") || string.equals("default")) {
            properties.remove("de.renew.remote.publicName");
            string = null;
        } else {
            properties.setProperty("de.renew.remote.publicName", string);
        }
        String string2 = this.tab.getServerClass().trim();
        if (string2.equals("") || string2.equals(RemoteExtension.DEFAULT_SERVER_CLASS.getName())) {
            properties.remove("de.renew.remote.serverClass");
            string2 = null;
        } else {
            properties.setProperty("de.renew.remote.serverClass", string2);
        }
        logger.debug((Object)("ConfigureRemoteAccessController: Configured enabled=" + bl + ", name=" + string + ", class=" + string2 + "."));
    }

    @Override
    public void updateTab(Properties properties) {
        this.tab.setRemoteEnabled(PropertyHelper.getBoolProperty((Properties)properties, (String)"de.renew.remote.enable"));
        String string = properties.getProperty("de.renew.remote.serverClass");
        if (string == null) {
            string = RemoteExtension.DEFAULT_SERVER_CLASS.getName();
        }
        this.tab.setServerClass(string);
        String string2 = properties.getProperty("de.renew.remote.publicName");
        if (string2 == null) {
            string2 = "default";
        }
        this.tab.setPublicName(string2);
        String string3 = properties.getProperty("de.renew.remote.socketFactory");
        if (string3 == null) {
            string3 = "";
        }
        this.tab.setSocketFactory(string3);
        this.enabledStateChanged();
    }

    void enabledStateChanged() {
        this.tab.enableDetailOptions(this.tab.getRemoteEnabled());
    }
}

