/*
 * Decompiled with CFR 0.152.
 */
package de.renew.netcomponents;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.gui.GuiPlugin;
import de.renew.netcomponents.ComponentsPluginExtender;
import de.renew.netcomponents.ComponentsTool;
import de.renew.netcomponents.GroupCommand;
import de.renew.netcomponents.RemoveLastNetComponentsToolCommand;
import de.renew.netcomponents.RemoveNetComponentsToolCommand;
import de.renew.netcomponents.RemoveToolsControl;
import de.renew.netcomponents.SelectNetComponentsToolCommand;
import de.renew.netcomponents.UngroupCommand;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class ComponentsToolPlugin
extends PluginAdapter {
    private CommandMenu _menu;
    private ComponentsTool defCT;
    private Vector componentsToolList = new Vector();
    private ImageIcon renewIcon;
    private static URL location;
    private Vector _pluginList;
    private Hashtable _commandList;

    public ComponentsToolPlugin(URL uRL) throws PluginException {
        super(uRL);
        this.setDefaultCT(null);
        ComponentsToolPlugin.setLocation(uRL);
        this._pluginList = new Vector();
    }

    public ComponentsToolPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
        this.setDefaultCT(null);
        ComponentsToolPlugin.setLocation(pluginProperties.getURL());
        this._pluginList = new Vector();
        this._commandList = new Hashtable();
    }

    public void init() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        this._menu = this.createMenu();
        MenuManager menuManager = drawPlugin.getMenuManager();
        menuManager.registerMenu("Tools", (JMenuItem)this._menu);
        String string = ComponentsTool.TOOLDIRPROPERTY;
        String string2 = this.getProperties().getProperty(string);
        if (string2 != null) {
            System.setProperty(string, string2);
            logger.debug((Object)("NetComponents: " + string + " set to " + string2));
            try {
                boolean bl;
                if (PropertyHelper.getBoolProperty((Properties)this.getProperties(), (String)"nc.init")) {
                    System.out.println("Your init option: de.renew.nc.init is set to true.");
                    System.out.println("This option is not supported anymore, whatsoever.");
                }
                if (bl = PropertyHelper.getBoolProperty((Properties)this.getProperties(), (String)"de.renew.nc.init")) {
                    System.out.println("Your init option: de.renew.nc.init is set to true.");
                    System.out.println("However, this is not supported anymore.");
                    System.out.println("Please set the init option of the plugin providing your default palette.");
                }
            }
            catch (RuntimeException runtimeException) {}
        } else {
            logger.error((Object)("NetComponents: " + string + " not set in plugin.cfg."));
        }
    }

    public void registerPlugin(IPlugin iPlugin) {
        this._pluginList.add(iPlugin);
        if (iPlugin instanceof ComponentsPluginExtender) {
            Vector vector = ((ComponentsPluginExtender)iPlugin).getMenuCommands();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Command command = (Command)iterator.next();
                this._menu.add(command);
                this._commandList.put(command, iPlugin);
                System.out.println("Added command " + command.toString() + " of Plugin " + iPlugin);
            }
        }
    }

    public void deregisterPlugin(IPlugin iPlugin) {
        Enumeration enumeration = this._commandList.keys();
        while (enumeration.hasMoreElements()) {
            Command command = (Command)enumeration.nextElement();
            if (!(this._commandList.get(command) instanceof ComponentsPluginExtender)) continue;
            this._menu.remove(command);
            this._commandList.remove(command);
        }
        this._pluginList.remove(iPlugin);
    }

    public boolean addEntryToMenu(Command command) {
        this._menu.add(command);
        return false;
    }

    public boolean removeEntryFromMenu(Command command) {
        this._menu.remove(command);
        return false;
    }

    public boolean cleanup() {
        this.unloadAllPalettes();
        DrawPlugin.getCurrent().getMenuManager().unregisterMenu((JMenuItem)this._menu);
        return true;
    }

    private void unloadAllPalettes() {
        Iterator iterator = this.componentsToolList.iterator();
        while (iterator.hasNext()) {
            ComponentsTool componentsTool = (ComponentsTool)iterator.next();
            componentsTool.remove();
        }
        this.componentsToolList = new Vector();
    }

    public void createPalette() {
        block7: {
            try {
                GuiPlugin guiPlugin = GuiPlugin.getCurrent();
                if (guiPlugin == null) {
                    logger.error((Object)"no gui starter object! cannot create palette.");
                }
                if (this.getDefaultCT() == null) {
                    ComponentsTool componentsTool = new ComponentsTool();
                    if (componentsTool.toolsDirIsValid()) {
                        this.componentsToolList.add(componentsTool);
                        this.setDefaultCT(componentsTool);
                    } else {
                        JOptionPane.showMessageDialog(guiPlugin.getGuiFrame(), "The '" + ComponentsTool.TOOLDIRPROPERTY + "' propery is not set to a valid net component directory." + "\n Set this property in \"renew.properties\" " + "in the \"config\" directory of your renew installation and restart the program" + "\nor use the menu entry \"Edit > Netcomponents > select from directory\"!", "Abort", 2, new ImageIcon(guiPlugin.getClass().getResource("/de/renew/gui/images/RENEW.gif")));
                    }
                } else {
                    this.getDefaultCT().remove();
                    this.componentsToolList.remove(this.getDefaultCT());
                    this.setDefaultCT(null);
                }
            }
            catch (Exception exception) {
                logger.error((Object)("Something went wrong while toggling the default palette. Palette is: " + this.getDefaultCT() + " Message: " + exception));
                if (this.getDefaultCT() == null) break block7;
                logger.error((Object)("Directory is: " + this.getDefaultCT().getLabel()));
            }
        }
    }

    public void selectDirAndCreatePalette() {
        File file = this.getDirectory();
        String string = "";
        if (file != null) {
            GuiPlugin guiPlugin = GuiPlugin.getCurrent();
            if (guiPlugin == null) {
                logger.error((Object)"no gui starter object! cannot create palette.");
            }
            try {
                string = file.getCanonicalPath();
            }
            catch (Exception exception) {
                logger.error((Object)("Scurity of FilePath violated. File: " + file.getName() + "\n Exception: " + exception));
            }
            ComponentsTool componentsTool = new ComponentsTool(string);
            if (componentsTool.toolsDirIsValid()) {
                this.componentsToolList.add(componentsTool);
            } else {
                JOptionPane.showMessageDialog(guiPlugin.getGuiFrame(), "No valid net component directory was selected.", "Abort", 2, new ImageIcon(guiPlugin.getClass().getResource("/de/renew/gui/images/RENEW.gif")));
            }
        }
    }

    public void createPalette(String string) {
        File file = new File(string);
        String string2 = string;
        if (file != null) {
            GuiPlugin guiPlugin = GuiPlugin.getCurrent();
            if (guiPlugin == null) {
                logger.error((Object)"no gui starter object! cannot create palette.");
            }
            try {
                string2 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                logger.error((Object)("Scurity of FilePath violated. File: " + file.getName() + "\n Exception: " + exception));
            }
            if (!this.componentsToolListcontains(string2)) {
                ComponentsTool componentsTool = new ComponentsTool(string2);
                if (componentsTool.toolsDirIsValid()) {
                    this.componentsToolList.add(componentsTool);
                } else {
                    JOptionPane.showMessageDialog(guiPlugin.getGuiFrame(), "No valid net component directory was selected.", "Abort", 2, new ImageIcon(guiPlugin.getClass().getResource("/de/renew/gui/images/RENEW.gif")));
                }
            }
        }
    }

    private boolean componentsToolListcontains(String string) {
        Iterator iterator = this.componentsToolList.iterator();
        while (iterator.hasNext()) {
            ComponentsTool componentsTool = (ComponentsTool)iterator.next();
            if (!componentsTool.getLabel().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void removeLastPalette() {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin == null) {
            logger.error((Object)"no gui starter object! cannot remove last palette.");
        }
        if (!this.componentsToolList.isEmpty()) {
            ComponentsTool componentsTool = (ComponentsTool)this.componentsToolList.lastElement();
            if (componentsTool == this.getDefaultCT()) {
                this.setDefaultCT(null);
            }
            componentsTool.remove();
            this.componentsToolList.remove(componentsTool);
            componentsTool = null;
        } else {
            guiPlugin.showStatus("Nothing to do.");
        }
    }

    public void removePalette() {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin == null) {
            logger.error((Object)"no gui starter object! cannot remove palette.");
        }
        if (!this.componentsToolList.isEmpty()) {
            new RemoveToolsControl(this);
        } else {
            guiPlugin.showStatus("Nothing to do.");
        }
    }

    public void removePalette(String string) {
        Iterator iterator = this.componentsToolList.iterator();
        ComponentsTool componentsTool = null;
        while (iterator.hasNext()) {
            ComponentsTool componentsTool2 = (ComponentsTool)iterator.next();
            if (!string.equals(componentsTool2.getLabel())) continue;
            componentsTool = componentsTool2;
        }
        if (componentsTool != null) {
            this.componentsToolList.remove(componentsTool);
            componentsTool.remove();
            componentsTool = null;
        }
    }

    public File getDirectory() {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin == null) {
            logger.error((Object)"no gui starter object! cannot create palette.");
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(guiPlugin.getGuiFrame());
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public Vector getCTList() {
        return this.componentsToolList;
    }

    public ComponentsTool getDefaultCT() {
        return this.defCT;
    }

    public void setDefaultCT(ComponentsTool componentsTool) {
        this.defCT = componentsTool;
    }

    public static URL getLocation() {
        return location;
    }

    public static void setLocation(URL uRL) {
        location = uRL;
    }

    private CommandMenu createMenu() {
        CommandMenu commandMenu = new CommandMenu("Netcomponents");
        commandMenu.add((Command)new SelectNetComponentsToolCommand((IPlugin)this));
        commandMenu.add((Command)new RemoveNetComponentsToolCommand((IPlugin)this));
        commandMenu.add((Command)new RemoveLastNetComponentsToolCommand((IPlugin)this));
        commandMenu.add((Command)new GroupCommand(), 49);
        commandMenu.add((Command)new UngroupCommand(), 51);
        commandMenu.addSeparator();
        commandMenu.add((Command)new VersionInfoCommand((IPlugin)this));
        commandMenu.addSeparator();
        commandMenu.add("Available Palettes");
        commandMenu.putClientProperty((Object)"ch.ifa.draw.menu.id", (Object)"de.renew.gui.nc");
        return commandMenu;
    }
}

