/*
 * Decompiled with CFR 0.152.
 */
package de.renew.netcomponents;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.Palette;
import de.renew.gui.GuiPlugin;
import de.renew.netcomponents.ComponentsToolPlugin;
import de.renew.netcomponents.InsertionTool;
import de.renew.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class ComponentsTool {
    public static Logger logger = Logger.getLogger((Class)ComponentsTool.class);
    protected static String TOOLDIRPROPERTY = "user.toolsdir";
    private Palette palette;
    private String label;
    private boolean toolsDirCheck = false;
    private boolean toolsDirIsSet = false;

    public ComponentsTool() {
        String string = System.getProperty(TOOLDIRPROPERTY);
        logger.debug((Object)string);
        if (string == null || !new File(string).exists()) {
            URL uRL = ComponentsToolPlugin.getLocation();
            String string2 = new File(uRL.getFile()).getAbsolutePath();
            if (new File(string2 = string2.substring(0, string2.lastIndexOf(File.separator)) + File.separator + "tools").exists()) {
                string = string2;
                this.toolsDirIsSet = true;
                GuiPlugin.getCurrent().showStatus("The " + TOOLDIRPROPERTY + " property is not set or not valid. Trying plugin location...");
                logger.debug((Object)("The " + TOOLDIRPROPERTY + " property is not set or not valid. Trying plugin location..."));
            } else {
                this.toolsDirIsSet = false;
                string = "";
                logger.info((Object)("Netcomponents: The " + TOOLDIRPROPERTY + " is not set! \n" + "Override by setting the " + TOOLDIRPROPERTY + " property."));
                logger.debug((Object)("netcomponents: using default tooldir '" + string + "'." + "Override by setting the " + TOOLDIRPROPERTY + " property."));
            }
        } else {
            this.toolsDirIsSet = true;
        }
        this.setLabel("default " + string);
        this.createTools(string);
    }

    public ComponentsTool(String string) {
        this.toolsDirIsSet = true;
        this.setLabel(string);
        this.createTools(string);
    }

    void createTools(String string) {
        String[] stringArray;
        JFrame jFrame;
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin == null) {
            logger.error((Object)"ComponentsPlugin: no GuiPlugin available!");
        }
        if ((jFrame = guiPlugin.getGuiFrame()) == null) {
            logger.error((Object)"NetComponents: could not create Tools: no GUI available.");
        }
        this.palette = new Palette(jFrame, "Components");
        File file = new File(string);
        File file2 = new File(string + File.separator + "images");
        Vector<String> vector = new Vector<String>();
        try {
            stringArray = new BufferedReader(new FileReader(string + File.separator + ".sequence"));
            while (stringArray.ready()) {
                vector.add(stringArray.readLine());
            }
            stringArray.close();
        }
        catch (Exception exception) {
            logger.error((Object)("The File" + string + File.separator + ".sequence" + " could not be found " + exception));
        }
        if (file.isDirectory()) {
            if (file2.isDirectory()) {
                String string2;
                String string3;
                stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    string3 = StringUtil.getFilename((String)stringArray[i]);
                    string2 = StringUtil.getExtension((String)stringArray[i]);
                    if (!new File(string + File.separator + stringArray[i]).isFile() || !"rnw".equals(string2) || vector.contains(string3)) continue;
                    vector.add(string3);
                }
                if (new File(string + File.separator + "images" + File.separator + "1.gif").exists()) {
                    Iterator iterator = vector.iterator();
                    while (iterator.hasNext()) {
                        string3 = (String)iterator.next();
                        string2 = this.createToolButton(string3, string, guiPlugin);
                        this.palette.add((ToolButton)string2);
                        this.toolsDirCheck = true;
                    }
                    if (this.toolsDirIsValid()) {
                        guiPlugin.getPaletteHolder().addPalette(this.palette);
                    }
                } else {
                    logger.error((Object)("The directory " + string + File.separator + "images seems to exist"));
                    logger.error((Object)"But it does not contain the files 1.gif 2.gif 3.gif ");
                    logger.error((Object)"So I think that the toolsdir variable is not set to a proper toolsdir directory.");
                    logger.error((Object)"A proper toolsdir directory contains the images directory  ");
                    logger.error((Object)"which contains at least the three above mentioned files.");
                    logger.error((Object)"");
                }
            } else {
                logger.error((Object)("The directory " + string + File.separator + "images does not exist!"));
            }
        } else {
            logger.error((Object)("The directory " + string + " does not exist!"));
        }
    }

    private ToolButton createToolButton(String string, String string2, GuiPlugin guiPlugin) {
        String string3 = string + ".rnw";
        Drawing drawing = DrawingFileHelper.loadDrawing((File)new File(string2, string3), (StatusDisplayer)GuiPlugin.getCurrent());
        Tool tool = this.createInsertionTool(guiPlugin, drawing);
        String string4 = "";
        String string5 = string2 + File.separator + "images" + File.separator + string;
        File file = new File(string5 + "1.gif");
        File file2 = new File(string5 + "2.gif");
        ImageIcon imageIcon = null;
        ImageIcon imageIcon2 = null;
        if (file.exists() && file2.exists()) {
            string4 = string;
            imageIcon = new ImageIcon(file.getAbsolutePath());
            imageIcon2 = new ImageIcon(file2.getAbsolutePath());
        } else {
            logger.debug((Object)("file does not exist: " + file.getAbsolutePath()));
        }
        ToolButton toolButton = guiPlugin.getPaletteHolder().createToolButton(string5, "NC " + string, tool);
        return toolButton;
    }

    private Tool createInsertionTool(GuiPlugin guiPlugin, Drawing drawing) {
        DrawingEditor drawingEditor = guiPlugin.getDrawingEditor();
        FigureEnumeration figureEnumeration = drawing.figures();
        Vector<Figure> vector = new Vector<Figure>();
        while (figureEnumeration.hasMoreElements()) {
            vector.addElement((Figure)figureEnumeration.nextElement());
        }
        InsertionTool insertionTool = new InsertionTool(drawingEditor, vector);
        return insertionTool;
    }

    public void remove() {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin != null) {
            guiPlugin.getPaletteHolder().removePalette(this.palette);
        }
    }

    private void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean toolsDirIsSet() {
        return this.toolsDirIsSet;
    }

    public boolean toolsDirIsValid() {
        return this.toolsDirCheck;
    }
}

