/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class ResponseDocument
extends PlainDocument {
    public static Logger logger = Logger.getLogger((Class)ResponseDocument.class);
    private final BufferedReader reader;
    private boolean terminated = false;
    private Object monitor = new Object();
    private Thread responseReaderThread;

    public ResponseDocument(PipedOutputStream pipedOutputStream) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(new PipedInputStream(pipedOutputStream)));
        this.responseReaderThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!ResponseDocument.this.terminated) {
                    try {
                        ResponseDocument.this.appendText(ResponseDocument.this.reader.readLine());
                    }
                    catch (IOException iOException) {
                        if ("Write end dead".equals(iOException.getMessage())) {
                            ResponseDocument.this.appendText("\n----\n");
                            Object object = ResponseDocument.this.monitor;
                            synchronized (object) {
                                try {
                                    ResponseDocument.this.monitor.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    logger.debug((Object)"Feedback thread interrupted.");
                                    ResponseDocument.this.appendText("\nFeedback thread interrupted.");
                                    ResponseDocument.this.terminate();
                                }
                                continue;
                            }
                        }
                        logger.debug((Object)("Feedback exception: " + iOException), (Throwable)iOException);
                        ResponseDocument.this.appendText("\nFeedback exception: " + iOException);
                        ResponseDocument.this.terminate();
                    }
                }
                ResponseDocument.this.appendText("\nFeedback terminated. Press [Clear] to reinitialize.");
            }
        };
        this.responseReaderThread.setName("GuiPrompt feedback reader thread");
        this.responseReaderThread.start();
    }

    public void appendText(String string) {
        try {
            this.insertString(this.getLength(), string + "\n", null);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)("Bad location!? getLength=" + this.getLength()), (Throwable)badLocationException);
        }
    }

    public void terminate() {
        this.terminated = true;
        this.responseReaderThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revive() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }
}

